package com.cx.cn.cxquartz.rabbitmq.comsumer.listener;

import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.rabbitmq.comsumer.TaskQSTConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.BatchMessageListener;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 批量分析图片
 */
@Component
public class TaskQSTReceiver implements BatchMessageListener {
    private static final Logger logger = LoggerFactory.getLogger(TaskQSTReceiver.class);
    @Autowired
    private TaskQSTConsumer taskQSTConsumer;


    @RabbitListener(queues = QueueConstants.QueueTaskConsumer.QUEUE+"_QST",containerFactory = "batchQueueRabbitListenerContainerFactory")
    @Override
    public void onMessageBatch(List<Message> messages) {
        try {
            if(messages.size()>0){
                taskQSTConsumer.consume(messages,null);
            }
        } catch (Exception e) {
                logger.error("批量分析图片 error:{}",e);
        }
    }
}
