package com.cx.cn.cxquartz.rabbitmq;

/**
 * 消息队列常量
 */
public class QueueConstants {

    /**
     * 任务队列常量
     */
    public interface QueueTaskConsumer{
        /**
         * 交换机名称
         */
        String EXCHANGE = "RabbitMQ.DirectExchange.TaskConsumer";
        /**
         * 队列名称
         */
        String QUEUE = "RabbitMQ.DirectQueue.TaskConsumer";
        /**
         * 路由键
         */
        String ROUTEKEY = "RabbitMQ.RouteKey.TaskConsumer";
    }

    /**
     * 消息通知队列
     */
    public enum QueueTaskEnum {
        QUEUE_TASK_ENUM(QueueConstants.QueueTaskConsumer.EXCHANGE, QueueConstants.QueueTaskConsumer.QUEUE,
                QueueConstants.QueueTaskConsumer.ROUTEKEY);
        /**
         * 交换机名称
         */
        private String exchange;
        /**
         * 队列名称
         */
        private String queue;
        /**
         * 路由键
         */
        private String routeKey;

        QueueTaskEnum(String exchange, String queue, String routeKey) {
            this.exchange = exchange;
            this.queue = queue;
            this.routeKey = routeKey;
        }

        public String getExchange() {
            return exchange;
        }

        public void setExchange(String exchange) {
            this.exchange = exchange;
        }

        public String getQueue() {
            return queue;
        }

        public void setQueue(String queue) {
            this.queue = queue;
        }

        public String getRouteKey() {
            return routeKey;
        }

        public void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }
    }

    /**
     * t推送第三方队列常量
     */
    public interface QueueSendToDXConsumer{
        /**
         * 交换机名称
         */
        String EXCHANGE = "RabbitMQ.DirectExchange.SendToDXConsumer";
        /**
         * 队列名称
         */
        String QUEUE = "RabbitMQ.DirectQueue.SendToDXConsumer";
        /**
         * 路由键
         */
        String ROUTEKEY = "RabbitMQ.RouteKey.SendToDXConsumer";
    }

    /**
     * 消息第三方声音告警队列
     */
    public enum QueueSendToDXEnum {
        QUEUE_SEND_TO_DX_ENUM(QueueConstants.QueueSendToDXConsumer.EXCHANGE, QueueConstants.QueueSendToDXConsumer.QUEUE,
                QueueConstants.QueueSendToDXConsumer.ROUTEKEY);
        /**
         * 交换机名称
         */
        private String exchange;
        /**
         * 队列名称
         */
        private String queue;
        /**
         * 路由键
         */
        private String routeKey;

        QueueSendToDXEnum(String exchange, String queue, String routeKey) {
            this.exchange = exchange;
            this.queue = queue;
            this.routeKey = routeKey;
        }

        public String getExchange() {
            return exchange;
        }

        public void setExchange(String exchange) {
            this.exchange = exchange;
        }

        public String getQueue() {
            return queue;
        }

        public void setQueue(String queue) {
            this.queue = queue;
        }

        public String getRouteKey() {
            return routeKey;
        }

        public void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }
    }


    /**
     * 推送第三方队列常量
     */
    public interface QueueSendToVoiceConsumer{
        /**
         * 交换机名称
         */
        String EXCHANGE = "RabbitMQ.DirectExchange.SendToVoiceConsumer";
        /**
         * 队列名称
         */
        String QUEUE = "RabbitMQ.DirectQueue.SendToVoiceConsumer";
        /**
         * 路由键
         */
        String ROUTEKEY = "RabbitMQ.RouteKey.SendToVoiceConsumer";
    }

    /**
     * 消息第三方队列
     */
    public enum QueueSendToVoiceEnum {
        QUEUE_SEND_TO_VOICE_ENUM(QueueConstants.QueueSendToVoiceConsumer.EXCHANGE, QueueConstants.QueueSendToVoiceConsumer.QUEUE,
                QueueConstants.QueueSendToVoiceConsumer.ROUTEKEY);
        /**
         * 交换机名称
         */
        private String exchange;
        /**
         * 队列名称
         */
        private String queue;
        /**
         * 路由键
         */
        private String routeKey;

        QueueSendToVoiceEnum(String exchange, String queue, String routeKey) {
            this.exchange = exchange;
            this.queue = queue;
            this.routeKey = routeKey;
        }

        public String getExchange() {
            return exchange;
        }

        public void setExchange(String exchange) {
            this.exchange = exchange;
        }

        public String getQueue() {
            return queue;
        }

        public void setQueue(String queue) {
            this.queue = queue;
        }

        public String getRouteKey() {
            return routeKey;
        }

        public void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }
    }



    /**
     * 获得rtsp 或者hls的队列
     */
    public interface QueueRTSPConsumer{
        /**
         * 交换机名称
         */
        String EXCHANGE = "RabbitMQ.DirectExchange.RTSPConsumer";
        /**
         * 队列名称
         */
        String QUEUE = "RabbitMQ.DirectQueue.RTSPConsumer";
        /**
         * 路由键
         */
        String ROUTEKEY = "RabbitMQ.RouteKey.RTSPConsumer";
    }

    /**
     * 消息第三方队列
     */
    public enum QueueRTSPEnum {
        QUEUE_RTSP_ENUM(QueueConstants.QueueRTSPConsumer.EXCHANGE, QueueConstants.QueueRTSPConsumer.QUEUE,
                QueueConstants.QueueRTSPConsumer.ROUTEKEY);
        /**
         * 交换机名称
         */
        private String exchange;
        /**
         * 队列名称
         */
        private String queue;
        /**
         * 路由键
         */
        private String routeKey;

        QueueRTSPEnum(String exchange, String queue, String routeKey) {
            this.exchange = exchange;
            this.queue = queue;
            this.routeKey = routeKey;
        }

        public String getExchange() {
            return exchange;
        }

        public void setExchange(String exchange) {
            this.exchange = exchange;
        }

        public String getQueue() {
            return queue;
        }

        public void setQueue(String queue) {
            this.queue = queue;
        }

        public String getRouteKey() {
            return routeKey;
        }

        public void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }
    }
    public enum QueueEventProcessingEnum {
        QUEUE_EVENT_PROCESSING_ENUM(QueueConstants.QueueEventProcessingConsumer.EXCHANGE, QueueConstants.QueueEventProcessingConsumer.QUEUE,
                QueueConstants.QueueEventProcessingConsumer.ROUTEKEY);
        /**
         * 交换机名称
         */
        private String exchange;
        /**
         * 队列名称
         */
        private String queue;
        /**
         * 路由键
         */
        private String routeKey;

        QueueEventProcessingEnum(String exchange, String queue, String routeKey) {
            this.exchange = exchange;
            this.queue = queue;
            this.routeKey = routeKey;
        }

        public String getExchange() {
            return exchange;
        }

        public void setExchange(String exchange) {
            this.exchange = exchange;
        }

        public String getQueue() {
            return queue;
        }

        public void setQueue(String queue) {
            this.queue = queue;
        }

        public String getRouteKey() {
            return routeKey;
        }

        public void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }
    }

    /**
     * 获得rtsp 或者hls的队列
     */
    public interface QueueEventProcessingConsumer{
        /**
         * 交换机名称
         */
        String EXCHANGE = "RabbitMQ.DirectExchange.EventProcessingConsumer";
        /**
         * 队列名称
         */
        String QUEUE = "RabbitMQ.DirectQueue.EventProcessingConsumer";
        /**
         * 路由键
         */
        String ROUTEKEY = "RabbitMQ.RouteKey.EventProcessingConsumer";



    }

    public enum QueueAutoSnapEnum {
        QUEUE_AUTOSNAP_ENUM(QueueConstants.QueueAutoSnapConsumer.EXCHANGE, QueueConstants.QueueAutoSnapConsumer.QUEUE,
                QueueConstants.QueueAutoSnapConsumer.ROUTEKEY);
        /**
         * 交换机名称
         */
        private String exchange;
        /**
         * 队列名称
         */
        private String queue;
        /**
         * 路由键
         */
        private String routeKey;

        QueueAutoSnapEnum(String exchange, String queue, String routeKey) {
            this.exchange = exchange;
            this.queue = queue;
            this.routeKey = routeKey;
        }

        public String getExchange() {
            return exchange;
        }

        public void setExchange(String exchange) {
            this.exchange = exchange;
        }

        public String getQueue() {
            return queue;
        }

        public void setQueue(String queue) {
            this.queue = queue;
        }

        public String getRouteKey() {
            return routeKey;
        }

        public void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }
    }
    /**
     * 获得rtsp 或者hls的队列
     */
    public interface QueueAutoSnapConsumer{
        /**
         * 交换机名称
         */
        String EXCHANGE = "RabbitMQ.DirectExchange.AutoSnapConsumer";
        /**
         * 队列名称
         */
        String QUEUE = "RabbitMQ.DirectQueue.AutoSnapConsumer";
        /**
         * 路由键
         */
        String ROUTEKEY = "RabbitMQ.RouteKey.AutoSnapConsumer";
    }
}
