package com.cx.cn.cxquartz.config;

import com.cx.cn.cxquartz.redis.Consumer;
import com.cx.cn.cxquartz.redis.OrderConsumer;
import com.cx.cn.cxquartz.redis.QueueConfiguration;
import com.cx.cn.cxquartz.redis.container.RedisMQConsumerContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * redis 消费者初始化
 */
@Configuration
public class RedisPCQueueConfig {

    @Autowired
    RedisMQConsumerContainer mqContainer;

    // 初始化完毕后调取 init
    @Bean(initMethod = "init", destroyMethod = "destroy")
    public RedisMQConsumerContainer redisQueueConsumerContainer() {
        for(int i=0;i<2;i++) {
            Consumer orderConsumer = new OrderConsumer();
            mqContainer.addConsumer(
                    QueueConfiguration.builder().queue("taskinfo").consumer(orderConsumer).build()
            );
        }
        return mqContainer;
    }
}
