package com.cx.cn.cxquartz.redis;

import com.alibaba.druid.util.HttpClientUtils;
import com.cx.cn.cxquartz.bean.QuartzTaskInformations;
import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.service.quartz.SbtdspsrService;
import com.cx.cn.cxquartz.service.quartz.impl.VideoRTSPorURLService;
import com.cx.cn.cxquartz.util.DateUtils;
import com.cx.cn.cxquartz.util.JsonUtil;
import com.cx.cn.cxquartz.vo.ResultObj;
import com.rabbitmq.tools.json.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.BatchingRabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;
import org.springframework.web.client.RestTemplate;

import javax.annotation.PostConstruct;
import java.io.File;
import java.util.*;

@Component
public class OrderConsumer implements  Consumer {
    public static final Logger log = LoggerFactory.getLogger(OrderConsumer.class);
    @Value("${local.czurl}")
    private String czurl;
    @Value("${local.fxurl}")
    private String fxurl;
    @Value("${file.recogurl}")
    private String recogurl;
    @Value("${file.model}")
    private String model;

    @Value("${local.czrooturl}")
    private String czrooturl;


    @Autowired
    private  VideoRTSPorURLService videoRTSPorURLService;

    @Autowired
    private  SbtdspsrService sbtdspsrService;
    @Autowired
    BatchingRabbitTemplate batchQueueRabbitTemplate;

    private static OrderConsumer orderConsumer;
    @Autowired
    private RestTemplate restTemplate;

    @PostConstruct
    public void init() {
        orderConsumer = this;
        orderConsumer.batchQueueRabbitTemplate = this.batchQueueRabbitTemplate;
        orderConsumer.czurl=this.czurl;
        orderConsumer.fxurl=this.fxurl;
        orderConsumer.recogurl=this.recogurl;
        orderConsumer.model=this.model;
        orderConsumer.videoRTSPorURLService=this.videoRTSPorURLService;
        orderConsumer.sbtdspsrService=this.sbtdspsrService;
        orderConsumer.restTemplate=this.restTemplate;
    }
    public OrderConsumer(){
    }

    @Override
    public void consume(Object message) {
        if(message instanceof QuartzTaskInformations){
            QuartzTaskInformations msg =(QuartzTaskInformations) message;
            try {
                //调用抽帧服务
                String  devicecode=msg.getExecuteparamter();
                String  rtsporhls="";
                log.info("开始消费消息{}", msg.getId());
                //如果设备编号是用一次废一次的，此刻需要现场取得rtsp
                if(null!=devicecode&&devicecode.startsWith("33") && devicecode.length()!=18){
                    //调用抽帧服务
                   String token= orderConsumer.videoRTSPorURLService.getRTSPAccessToekenByDeviceCode(devicecode);
                    rtsporhls=orderConsumer.videoRTSPorURLService.getRTSPByDeviceCode(token,devicecode);
                }
                else{
                    //取表里最新的rtsp 或者hls 的值
                    rtsporhls=orderConsumer.sbtdspsrService.getRtspOrHLSByDeviceCode(devicecode);
                }

                if(rtsporhls.equals("")){
                    //尝试重新抽帧一遍
                    String token= orderConsumer.videoRTSPorURLService.getRTSPAccessToekenByDeviceCode(devicecode);
                    rtsporhls=orderConsumer.videoRTSPorURLService.getRTSPByDeviceCode(token,devicecode);
                    if(rtsporhls.equals("")) {
                        log.error(devicecode + "rtsp 、hls 地址为空");
                        return;
                    }
                }
                //将rtsp 作为参数调用抽帧服务


//                 String  result="{\n" +
//                         "    \"ret\": 0,\n" +
//                         "    \"desc\": \"succ!\",\n" +
//                         "    \"resourcePath\": \"http://zjh189.ncpoi.cc:7080/download/202109/08/33050300001327599605/33050300001327599605_20210908_134131031.jpg\",\n" +
//                         "    \"localuri\": \"/home/ubuntu/pictures/slice/202109/08/33050300001327599605/33050300001327599605_20210908_134131031.jpg\",\n" +
//                         "    \"timestamp\": \"2021-09-08 13:41:31.031\",\n" +
//                         "    \"devicecode\": \"33050300001327599605\"\n" +
//                         "}";
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                Map map=new HashMap();
                map.put("resourcePath",orderConsumer.czrooturl+"/"+ DateUtils.formatCurrDateYYMM()+"/"+devicecode+"/"+devicecode+"_"+DateUtils.formatCurrDayNoSign()+"_"+DateUtils.formatCurrDateHHmmss()+".jpg");
                map.put("deviceID",devicecode);
                map.put("resourceParam",rtsporhls);
               HttpEntity<Map> requestEntity = new HttpEntity<>(map, headers);
               String response= orderConsumer.restTemplate.postForObject(orderConsumer.czurl,requestEntity, String.class);
               Map resultmap  =JsonUtil.strToObj(response,Map.class);
               if(null!=resultmap.get("ret")) {
                    if (resultmap.get("ret").toString().equals("0")
                            && null!=resultmap.get("resourcePath")
                            && !resultmap.get("resourcePath").toString().equals("")) {
                        //抽帧结果放到rabbttmq 中，根据msg 的检测metatype ,分别派发到不同的queue中，方便以后10条10条的去皮皮昂分析
                        Map m = new HashMap();
                        m.put("task", JsonUtil.objToStr(msg));
                        m.put("result", response);
                        CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
                        orderConsumer.batchQueueRabbitTemplate.send(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getExchange(),
                                QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey() + "_QST",
                                MessageHelper.objToMsg(m),
                                correlationData);
                    }
                    else{
                        log.error("抽帧失败",JsonUtil.objToStr(resultmap));
                    }
                }
                else{

                    log.error("返回状态码为null");

                }
//                  String roistr= URLEncoder.encode("[")+msg.getObjectx()+","+msg.getObjecty()+","+msg.getObjectw()+","+msg.getObjecth()+URLEncoder.encode("]");
//                String result= CompletableFuture.supplyAsync(() -> HttpClientUtil.doGet(orderConsumer.recogurl + "?deviceCode="+msg.getExecuteparamter()+"&model="+orderConsumer.model+"&roi="+roistr)).get(2, TimeUnit.SECONDS);


//                String roistr= URLEncoder.encode("[")+msg.getObjectx()+","+msg.getObjecty()+","+msg.getObjectw()+","+msg.getObjecth()+URLEncoder.encode("]");
////                String result= CompletableFuture.supplyAsync(() -> HttpClientUtil.doGet(orderConsumer.recogurl + "?deviceCode="+msg.getExecuteparamter()+"&model="+orderConsumer.model+"&roi="+roiarray)).get(2, TimeUnit.SECONDS);
//                log.info(" deviceCode:{} ",msg.getExecuteparamter());
//                String result = HttpClientUtil.doGet(orderConsumer.recogurl + "?deviceCode=" + msg.getExecuteparamter() + "&model=" + orderConsumer.model + "&roi=" + roistr);
//                log.info(" picture result:{} ",result);
//                if (null != result && result.contains("ret"))//放入rabbitmq.数据由消费者去处理
//                {
//                    Map objresult = JsonUtil.strToObj(result, Map.class);
//                    //处理消息
//                    if (null != objresult.get("ret") && objresult.get("ret").toString().equals("0")
//                            && null != objresult.get("desc")
//                            && objresult.get("desc").toString().contains("succ")) {
//                        Map m = new HashMap();
//                        m.put("task", JsonUtil.objToStr(msg));
//                        m.put("result", result);
//                        String msgId = UUID.randomUUID().toString();
//                        CorrelationData correlationData = new CorrelationData(msgId);
//                        //根绝不同的检测事件对象metatype分发到不同的通道
//
//                        orderConsumer.rabbitTemplate.convertAndSend(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getExchange(),
//                                QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey(),
//                                MessageHelper.objToMsg(m),
//                                correlationData);
//                    }
//                }
                //添加具体的消费逻辑，修改数据库什么的
                log.info("消费消息{}完成", msg.getId());
            }catch (Exception ex){
                log.error("消费消息{}error:{}", msg.getId(), ex.toString());
            }
        }
    }
}
