package com.cx.cn.cxquartz.controller;


import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.util.*;
import com.cx.cn.cxquartz.vo.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.*;

@RestController
@Api(description ="Զץͷͷӿ",tags = "Զץͷͷ")
public class AutoSnapController {
    private static final Logger logger = LoggerFactory.getLogger(ExtController.class);

    @Autowired
    RabbitTemplate rabbitTemplate;

    @Value("${file.rootpath}")
    String rootpath;


    @RequestMapping(value = "/AutoSnap", method = RequestMethod.POST)
    @ApiOperation(value = "Զץͷͷ",notes = "ϴxmljpgļ")
    public void AutoSnap(@RequestParam("file") MultipartFile[] file) {
        /*ļΪգļ*/
        if (file != null && file.length>0 && file.length==2) {
            //xmlļ jpgļ
            MultipartFile  filexml=file[0].getName().endsWith(".xml")==true?file[0]:file[1];
            MultipartFile  filejpg=file[0].getName().endsWith(".jpg")||file[0].getName().endsWith(".jpeg") ==true?file[0]:file[1];

            //xmlļϢͼƬַϢַϳrabbitmq еĸʽ
            try {
                Document doc= XmlUtils.readDocument(filexml);
                Capture vCACapture=new Capture();
                XmlUtils.parseDocument(vCACapture,doc);
                vCACapture.setDateTime(vCACapture.getDateTime()==null?null:DateUtils.dealDateFormat(vCACapture.getDateTime()));
                //jpg ļļŵĳ·
                    Calendar    rightNow    =   Calendar.getInstance();
                    String  filepath=rootpath+File.separator+rightNow.get(Calendar.YEAR)+File.separator+rightNow.get(Calendar.MONTH)+File.separator+vCACapture.getDeviceId()+File.separator+vCACapture.getDeviceId()+"_"+DateUtils.formatDateToNoSign(vCACapture.getDateTime())+".jpg";
                    //ļcopy·
                    File desfile=new File(filepath);
                    if (!desfile.getParentFile().exists()) {
                        desfile.getParentFile().mkdirs();
                    }
                    if (!desfile.exists()) {
                        desfile.createNewFile();
                    }
                    filejpg.transferTo(desfile);
                    //
                    Map map=new HashMap<>();
                    map.put("resourcePath",filepath);
                    map.put("timestamp", vCACapture.getDateTime() );
                    map.put("devicecode", vCACapture.getDeviceId());
                    CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
                    rabbitTemplate.convertAndSend(QueueConstants.QueueAutoSnapEnum.QUEUE_AUTOSNAP_ENUM.getExchange(),
                            QueueConstants.QueueAutoSnapEnum.QUEUE_AUTOSNAP_ENUM.getRouteKey(),
                            MessageHelper.objToMsg(map),
                            correlationData);
                    //ƴΪ¸ʽ
//                    String  result="{\n" +
//                            "    \"ret\": 0,\n" +
//                            "    \"desc\": \"succ!\",\n" +
//                            "    \"url\": \"http://zjh189.ncpoi.cc:7080/download/202109/08/33050300001327599605/33050300001327599605_20210908_134131031.jpg\",\n" +
//                            "    \"resourcePath\": \"/home/ubuntu/pictures/slice/202109/08/33050300001327599605/33050300001327599605_20210908_134131031.jpg\",\n" +
//                            "    \"timestamp\": \"2021-09-08 13:41:31.031\",\n" +
//                            "    \"devicecode\": \"33050300001327599605\"\n" +
//                            "}";
            } catch (IOException e) {
                e.printStackTrace();
                logger.error("IOException",e);
            }
        }else{
        logger.error("ļ2");
        }
    }


}
