package com.cx.cn.cxquartz.redis.container;

import com.cx.cn.cxquartz.redis.QueueConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
@Component
public class RedisMQConsumerContainer {
    public static final Logger log = LoggerFactory.getLogger(RedisMQConsumerContainer.class);
    public static boolean RUNNING;

    @Autowired
    private RedisTemplate redisTemplate;

    private Map<String,QueueConfiguration> consumerMap= new HashMap<>();

    private ExecutorService executor;

    public RedisMQConsumerContainer() {
        init();
    }

    public void addConsumer(QueueConfiguration configuration) {
        if (configuration.getConsumer() == null) {
            log.warn("Key:{} consumer cannot be null, this configuration will be skipped", configuration.getQueue());
        }
        executor.submit(new QueueListener(redisTemplate,configuration.getQueue(),configuration.getConsumer()));
        log.info("队列 {} 提交消息任务",configuration.getQueue());

    }

    public void destroy() {
        log.info("Redis消息队列线程池关闭中");
        RUNNING = false;
        this.executor.shutdown();
        log.info("QueueListener exiting.");
        while (!this.executor.isTerminated()) {

        }
        log.info("QueueListener exited.");
    }

    public void init() {
        log.info("消息队列线程池初始化");
        RUNNING = true;
        this.executor= Executors.newCachedThreadPool();
//        this.executor = Executors.newCachedThreadPool(r -> {
//            final AtomicInteger threadNumber = new AtomicInteger(10);
//            return new Thread(r, "RedisMQListener-" + threadNumber.getAndIncrement());
//        });
    }
}