package com.cx.cn.cxquartz.config;

import com.google.common.base.Predicates;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class Swagger2Config {
    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo()).select().apis(RequestHandlerSelectors.any())
                .paths(Predicates.not(PathSelectors.regex("/error.*"))).paths(Predicates.not(PathSelectors.regex("/info.*")))
                .paths(Predicates.not(PathSelectors.regex("/autoconfig.*")))
                .paths(Predicates.not(PathSelectors.regex("/health.*")))
                .paths(Predicates.not(PathSelectors.regex("/metrics.*")))
                .paths(Predicates.not(PathSelectors.regex("/mappings.*")))
                .paths(Predicates.not(PathSelectors.regex("/trace.*")))
                .paths(Predicates.not(PathSelectors.regex("/configprops.*")))
                .paths(Predicates.not(PathSelectors.regex("/beans.*"))).paths(Predicates.not(PathSelectors.regex("/env.*")))
                .paths(Predicates.not(PathSelectors.regex("/dump.*")))
                .paths(Predicates.not(PathSelectors.regex("/auditevents.*")))
                .paths(Predicates.not(PathSelectors.regex("/docs.*"))).paths(Predicates.not(PathSelectors.regex("/archaius.*")))
                .paths(Predicates.not(PathSelectors.regex("/features.*")))
                .paths(Predicates.not(PathSelectors.regex("/pause.*"))).paths(Predicates.not(PathSelectors.regex("/refresh.*")))
                .paths(Predicates.not(PathSelectors.regex("/resume.*")))
                .paths(Predicates.not(PathSelectors.regex("/actuator.*")))
                .paths(Predicates.not(PathSelectors.regex("/jolokia.*")))
                .paths(Predicates.not(PathSelectors.regex("/loggers.*")))
                .paths(Predicates.not(PathSelectors.regex("/restart.*")))
                .paths(Predicates.not(PathSelectors.regex("/service-registry/instance-status.*")))
                .paths(Predicates.not(PathSelectors.regex("/logfile.*")))
                .paths(Predicates.not(PathSelectors.regex("/channels.*"))).paths(Predicates.not(PathSelectors.regex("/bus.*")))
                .paths(Predicates.not(PathSelectors.regex("/heapdump.*"))).build();
    }

    /**
     * Swagger2Ϣ,apiĻϢչʾ
     *
     * @return
     */
    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("videoӿڶ͹淶").description("knotvideoӿڶ͹淶")
                .termsOfServiceUrl("http://****.com/").contact(new Contact("@****.com", "", "")).version("1.0")
                .license("Ȩ ?***").build();
    }
}
