package com.cx.cn.cxquartz.service.quartz.impl;

import com.cx.cn.cxquartz.dao.TraffPictureMapper;
import com.cx.cn.cxquartz.service.quartz.TraffPictureService;
import com.cx.cn.cxquartz.util.*;
import com.cx.cn.cxquartz.vo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.*;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author wjj
 * @since 2021-04-29
 */
@Service
public class EventWriteService {
    private static final Logger log = LoggerFactory.getLogger(EventWriteService.class);

    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private TraffPictureMapper traffPictureMapper;

    @Value("${countryside.eventwrite.url}")
    private String url;

    @Value("${voice.url}")
    private String voiceurl;


    @Value("${countryside.eventwrite.timeout}")
    private Integer timeout;


    @Value("${countryside.eventwrite.token}")
    private String qztoken;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    TraffPictureService traffPictureService;

    @Autowired
    TokenCacheService tokensertvice;

    @Value("${local.czurl}")
    private String czurl;
    @Value("${local.fxurl}")
    private String fxurl;
    @Value("${file.rootpath}")
    private String filerootpath;
    @Value("${file.outpath}")
    private String outpath;


    @Value("${file.uploadurl}")
    private String uploadurl;
    public void sendEvent(TraffpictureParam traffpictureParamresult, TraffrecordData sendtozhiui) {
        if (traffpictureParamresult.getTargetnum().contains("/")) {
            sendtozhiui.setAlarmnum(Integer.parseInt(traffpictureParamresult.getTargetnum().split("/")[1]));
        } else {
            sendtozhiui.setAlarmnum(Integer.parseInt(traffpictureParamresult.getTargetnum()));
        }
        sendtozhiui.setFdid(traffpictureParamresult.getFdid());
        sendtozhiui.setRecordtype(traffpictureParamresult.getRecordtype());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sendtozhiui.setRecordtime(traffpictureParamresult.getCreatetime() == null ? "" : format.format(traffpictureParamresult.getCreatetime()));
        ResultObj resultObj;
        try {
            resultObj = sendMessage(sendtozhiui);
            traffpictureParamresult.setPushdesc(resultObj.getMsg());
            /* 成功 */
            if ("0".equals(resultObj.getCode())) {
                traffpictureParamresult.setPushstatus(0);
                traffpictureParamresult.setPushdesc("推送成功");
                traffPictureMapper.updateTraffpicturePushStatus(traffpictureParamresult);
                return;
            }
        } catch (TimeoutException e) {
            traffpictureParamresult.setPushdesc("请求超时");
            log.error("eventwrite - sendEvent 请求超时:" + e.toString());
            //return ResultObj.error(ResponseEnum.E_1008.getCode(), ResponseEnum.E_1008.getMsg());
        } catch (Exception e) {
            traffpictureParamresult.setPushdesc("请求失败");
            log.error("eventwrite - sendEvent 异常:" + e.toString());
            //return ResultObj.error(ResponseEnum.E_9999.getCode(), e.toString());
        }
        traffpictureParamresult.setPushstatus(-1);
        traffPictureMapper.updateTraffpicturePushStatus(traffpictureParamresult);
    }

    public void sendVoice(VoiceData voice) {
        VoiceResultObj result;
        try {
            result = sendVoioceMessage(voice);
            if (result.getCode() == 1) {
                log.info(" push to  voice success");
            } else {
                log.info(" push to  voice result:{}", JsonUtil.objToStr(result));
            }
        } catch (TimeoutException e) {
            log.error("push to  voice  请求超时:" + e.toString());
        } catch (Exception e) {
            log.error("push to  voice  异常:" + e.toString());
        }
    }

    private ResultObj sendMessage(TraffrecordData traffalarmrecord) throws InterruptedException, ExecutionException, TimeoutException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String token = stringRedisTemplate.opsForValue().get(qztoken);
        if (null == token) {
            token = tokensertvice.keepAlive();
        }
        headers.add("accessToken", token);
        HttpEntity<TraffrecordData> requestEntity = new HttpEntity<>(traffalarmrecord, headers);
        return CompletableFuture.supplyAsync(() -> restTemplate.postForObject(url, requestEntity, ResultObj.class)).get(timeout, TimeUnit.SECONDS);
    }

    private ResultObj sendToCalluri(JobTjParam jobTjParam, String callbackurl) throws InterruptedException, ExecutionException, TimeoutException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<JobTjParam> requestEntity = new HttpEntity<>(jobTjParam, headers);
        return CompletableFuture.supplyAsync(() -> restTemplate.postForObject(callbackurl, requestEntity, ResultObj.class)).get(timeout, TimeUnit.SECONDS);
    }

    private ResultObj sendToCalluriSync(JobTjParam jobTjParam, String callbackurl) throws InterruptedException, ExecutionException, TimeoutException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<JobTjParam> requestEntity = new HttpEntity<>(jobTjParam, headers);
        return restTemplate.postForObject(callbackurl, requestEntity, ResultObj.class);
    }

    public void sendEventByCallUrl(TraffpictureParam traffpictureParamresult, JobTjParam jobTjParam, String callbackurl) {
        ResultObj resultObj;
        try {
            resultObj = sendToCalluri(jobTjParam, callbackurl);
            traffpictureParamresult.setPushdesc(resultObj.getMsg());
            if ("0".equals(resultObj.getCode())) {
                traffpictureParamresult.setPushstatus(0);
                traffPictureMapper.updateTraffpicturePushStatus(traffpictureParamresult);
                return;
            }
        } catch (Exception e) {
            traffpictureParamresult.setProcessstatus("-2");
            traffpictureParamresult.setPushdesc("推送第三方失败");
            log.error("eventwrite - sendEventByCallUrl 异常:" + e.toString());
            //return ResultObj.error(ResponseEnum.E_9999.getCode(), e.toString());
        }
        traffpictureParamresult.setPushstatus(-1);
        traffPictureMapper.updateTraffpicturePushStatus(traffpictureParamresult);
    }

    public void sendEventByCallUrl(Long id, JobTjParam jobTjParam, String callbackurl) {
        ResultObj resultObj;
        TraffpictureParam traffpictureParamresult = new TraffpictureParam();
        traffpictureParamresult.setId(id);
        try {
            resultObj = sendToCalluriSync(jobTjParam, callbackurl);
            traffpictureParamresult.setPushdesc(resultObj.getMsg());
            if ("0".equals(resultObj.getCode())) {
                traffpictureParamresult.setPushstatus(0);
                traffPictureMapper.updateTraffpicturePushStatus(traffpictureParamresult);
                return;
            }
        } catch (Exception e) {
            traffpictureParamresult.setProcessstatus("-2");
            traffpictureParamresult.setPushdesc("推送第三方失败");
            log.error("eventwrite - sendEventByCallUrl 异常:" + e.toString());
        }
        traffpictureParamresult.setPushstatus(-1);
        traffPictureMapper.updateTraffpicturePushStatus(traffpictureParamresult);
    }

    private VoiceResultObj sendVoioceMessage(VoiceData voiceData) throws InterruptedException, ExecutionException, TimeoutException {
        HttpHeaders headers = new HttpHeaders();
        HttpEntity<VoiceData> requestEntity = new HttpEntity<>(voiceData, headers);
        return restTemplate.postForObject(voiceurl, requestEntity, VoiceResultObj.class);
    }


    public TraffpictureParam getResult(TraffpictureParam traffpictureParamresult, int tarnum, Long[] roiarray, String imgurl,
                                       List<Map> objectList,
                                       JobTjParam jobTjParam, List<Map> detectObjects) {
        Map obj = new HashMap();
        String recordtype = jobTjParam.getDetectType();
        //判断是否统计结构化数据
        traffpictureParamresult.setImagedata(imgurl);

        //人群统计
        if ("10".equals(recordtype)) {
            int larmnum = getManNumber(objectList);
            //获得所有对象的坐标
            if (tarnum < larmnum) {
                traffpictureParamresult.setTargetnum(String.valueOf(larmnum));
                obj.put("objectCount", larmnum);
            } else {
                return null;
            }
            traffpictureParamresult.setTargetnum(String.valueOf(larmnum)+"/"+tarnum);
        }
        //人群总数和戴口罩统计
        else if ("60".equals(recordtype)) {
            int larmnum = getManNumber(objectList);
            int masknum = 0;
            obj.put("alarmNum", tarnum);
            //判断戴口罩多少人
            for (Map traffpictureParam : objectList) {
                if (null != traffpictureParam) {
                    Map metadata = (Map) traffpictureParam.get("Metadata");
                    if (null != metadata.get("HasMask") && metadata.get("HasMask").toString().equals("1")) {
                        masknum++;
                    }
                }
            }
            //获得所有对象的坐标
            obj.put("objectCount", masknum + "/" + larmnum+"/"+tarnum);
            traffpictureParamresult.setTargetnum(masknum + "/" + larmnum);
        } else if ("12".equals(recordtype)) {//单独的结构化统计
            obj.put("alarmNum", objectList.size());
            traffpictureParamresult.setTargetnum(String.valueOf(objectList.size()));
        }
        //获得所有对象的坐标
        for (Map traffpictureParam : objectList) {
            //根据imageid  获得  base64图片
            Map metadata = (Map) traffpictureParam.get("Metadata");
            if (metadata.size() > 0) {
                Map objlocation = getObjectPoint(metadata, roiarray, traffpictureParamresult, recordtype);
                if (null == objlocation) {
                    log.info("点位未空");
                    continue;
                }
                //获得特征属性
                getDetectInfo(recordtype, metadata, objlocation);
                detectObjects.add(objlocation);
            }
        }
        if (detectObjects.size() == 0) {
            log.info(" 特征对象为空  ");
            return null;
        }
        obj.put("detectObjects", detectObjects);
        jobTjParam.setDetectInfo(obj);
        jobTjParam.setTimestamp(new Date().getTime());
        return traffpictureParamresult;
    }

    public void setTraffpictureParam(String recordtype, String sbbh, String createtime,
                                     TraffpictureParam traffpictureParam) {
//        traffpictureParam.setAreaid(Long.parseLong("-1"));
        traffpictureParam.setFdid(sbbh);
        traffpictureParam.setChannelid(0);
        if (createtime.contains(".")) {
            traffpictureParam.setCreatetime(createtime.split("\\.")[0]);
        } else {
            traffpictureParam.setCreatetime(createtime);
        }
        //默认未处理
        traffpictureParam.setProcessstatus("0");
        traffpictureParam.setRecordtype(recordtype);
        //判断是否自动推送，如果是自动推送则设置推送状态为推送成功

        traffpictureParam.setCheckstatus(0);
        traffPictureService.inserTraffpicture(traffpictureParam);
    }

    public int getManNumber(List<Map> objectList) {
        int objsize = 0;
        for (Map traffpictureParam : objectList) {
            //根据imageid  获得  base64图片
            Map metadata = (Map) traffpictureParam.get("Metadata");
            if (metadata.size() == 0) continue;
            String metadatatyp = metadata.get("Type").toString();
            if ("1".equals(metadatatyp) || "4".equals(metadatatyp)
                    || "3".equals(metadatatyp)) {
                //返回结果是人相关的
                objsize++;
            }
        }
        return objsize;
    }

    public Map getObjectPoint(Map metadata, Long[] roiarray, TraffpictureParam traff, String recordtype) {
        Map objlocation = new HashMap();
        Location lo = null;
        Map objectBoundingBox = (Map) metadata.get("ObjectBoundingBox");
        if (null != metadata.get("LeftTopX") &&
                !"".equals(metadata.get("LeftTopX").toString())
                && null != metadata.get("LeftTopY")
                && !"".equals(metadata.get("LeftTopY").toString())
                && null != metadata.get("RightBtmX")
                && !"".equals(metadata.get("RightBtmX").toString())
                && null != metadata.get("RightBtmY")
                && !"".equals(metadata.get("RightBtmY").toString())
        ) {
            try {
                lo = new Location(
                        Integer.parseInt(metadata.get("LeftTopX").toString()) + roiarray[0].intValue(),
                        Integer.parseInt(metadata.get("LeftTopY").toString()) + roiarray[1].intValue(),
                        Integer.parseInt(metadata.get("RightBtmX").toString()) + roiarray[0].intValue(),
                        Integer.parseInt(metadata.get("RightBtmY").toString()) + roiarray[1].intValue()
                );
            } catch (Exception ex) {
                log.error(ex.toString());
            }
        } else if (null != objectBoundingBox) {
            try {
                lo = new Location(Integer.parseInt(objectBoundingBox.get("x").toString()) + roiarray[0].intValue(),
                        Integer.parseInt(objectBoundingBox.get("y").toString()) + roiarray[1].intValue(),
                        Integer.parseInt(objectBoundingBox.get("x").toString()) + Integer.parseInt(objectBoundingBox.get("w").toString()) + roiarray[0].intValue(),
                        Integer.parseInt(objectBoundingBox.get("y").toString()) + Integer.parseInt(objectBoundingBox.get("h").toString()) + roiarray[1].intValue()
                );
            } catch (Exception ex) {
                log.error(ex.toString());
            }
        } else {
            if (null != metadata.get("FaceBoundingBox")) {
                try {
                    Map faceBoundingBox = (Map) metadata.get("FaceBoundingBox");
                    lo = new Location(
                            Integer.parseInt(faceBoundingBox.get("x").toString()) + roiarray[0].intValue(),
                            Integer.parseInt(faceBoundingBox.get("y").toString()) + roiarray[1].intValue(),
                            Integer.parseInt(faceBoundingBox.get("x").toString()) +
                                    Integer.parseInt(faceBoundingBox.get("w").toString()) + roiarray[0].intValue(),
                            Integer.parseInt(faceBoundingBox.get("y").toString()) +
                                    Integer.parseInt(faceBoundingBox.get("h").toString()) + roiarray[1].intValue()
                    );
                } catch (Exception ex) {
                    log.error(ex.toString());
                }
            } else {
                if (null != metadata.get("HeadBoundingBox")) {
                    try {
                        Map headBoundingBox = (Map) metadata.get("HeadBoundingBox");
                        lo = new Location(
                                Integer.parseInt(headBoundingBox.get("x").toString()) + roiarray[0].intValue(),
                                Integer.parseInt(headBoundingBox.get("y").toString()) + roiarray[1].intValue(),
                                Integer.parseInt(headBoundingBox.get("x").toString()) + Integer.parseInt(headBoundingBox.get("w").toString()) + roiarray[0].intValue(),
                                Integer.parseInt(headBoundingBox.get("y").toString()) + Integer.parseInt(headBoundingBox.get("h").toString()) + roiarray[1].intValue()
                        );
                    } catch (Exception ex) {
                        log.error(ex.toString());
                    }
                }
            }
        }
        if (null != lo) {
            objlocation.put("location", lo);
            traff.setObjx(lo.getX1() < lo.getX2() ? lo.getX1() : lo.getX2());
            traff.setObjy(lo.getY1() < lo.getY2() ? lo.getY1() : lo.getY2());
            traff.setObjw(lo.getX1() < lo.getX2() ? lo.getX2() - lo.getX1() : lo.getX1() - lo.getX2());
            traff.setObjh(lo.getY1() < lo.getY2() ? lo.getY2() - lo.getY1() : lo.getY1() - lo.getY2());
            return objlocation;
        } else {
            return null;
        }
    }

    public void getDetectInfo(String recordtype, Map metadata, Map objlocation) {
        String metatype = metadata.get("Type").toString();
        if ("20".equals(recordtype)) {//周界入侵，展示objectType
            objlocation.put("objectType", metatype);
        } else if ("41".equals(recordtype)) {
            //汽车
            if ("2".equals(metatype)) {
                objlocation.put("carNo", String.valueOf(metadata.get("PlateNo")));
                objlocation.put("carBrand", String.valueOf(metadata.get("carBrand")));
            }
        } else if ("42".equals(recordtype)) {
            //非机动车
            if ("4".equals(metatype)) {
                objlocation.put("bikeClassType", String.valueOf(metadata.get("BikeClass")));
            }
        } else if ("43".equals(recordtype)) {
            if ("4".equals(metatype)) {
                int helmet = Integer.parseInt(metadata.get("Helmet").toString());
                //非机动车未戴头盔
                if (helmet == 0) {
                    objlocation.put("helmet", helmet);
                }
            }
        } else if ("50".equals(recordtype)) {
            if ("1".equals(metatype) || "3".equals(metatype) || "4".equals(metatype)) {
                int mask = Integer.parseInt(metadata.get("HasMask").toString());
                //佩戴口罩识别
                objlocation.put("mask", mask);
            }
        }
    }

    public void uploadPicture(TraffpictureParam traffpictureParam, String url, List<Map> points, String basepath, String filename) {
        try {
            //completionService.submit(() -> {
            InputStream streanm = RestUtil.ReadFromURL(url);
            ByteArrayOutputStream bos = PointUtil.drawByPoints(streanm, points);
            if (null == bos) {
                log.error("picture is null");
            }
            File file = FileUtil.uploadToLocal(filerootpath + File.separator +
                    outpath + File.separator +
                    basepath, bos, filename);
            if (null == file) {
                log.error("picture upload  error");
            }
        } catch (Exception ex) {
            log.error(" uplaod file:{}", ex.toString());
        }
    }
}