package com.cx.cn.cxquartz.rabbitmq.comsumer.listener;

import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.rabbitmq.comsumer.BaseConsumer;
import com.cx.cn.cxquartz.rabbitmq.comsumer.BaseConsumerProxy;
import com.cx.cn.cxquartz.rabbitmq.comsumer.SendToVoiceConsumer;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;

/**
 * 推送给声音告警队列的监听
 */
@Component
public class SendtoVoiceAlarmReceiver {
    private static final Logger logger = LoggerFactory.getLogger(SendtoVoiceAlarmReceiver.class);
    @Autowired
    private SendToVoiceConsumer sendToVoiceConsumer;
    /**
     * 消息接收处理
     *
     * @param message
     * @param channel
     * @throws IOException
     */
    @RabbitListener(queues = QueueConstants.QueueSendToVoiceConsumer.QUEUE)
    public void consume(Message message, Channel channel){
        try {
//            logger.info("SendtoVoiceAlarmReceiver body:{}", message.getBody());
            BaseConsumerProxy baseConsumerProxy = new BaseConsumerProxy(sendToVoiceConsumer);
            BaseConsumer proxy = (BaseConsumer) baseConsumerProxy.getProxy();
            if (null != proxy) {
                proxy.consume(message, channel);
            }
        }catch (Exception ex){
            logger.error("SendtoVoiceReceiver error:{}", ex.toString());
        }
    }
}
