package com.cx.cn.cxquartz.service.quartz.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Service
public class TokenCacheService {

    private static final Logger log = LoggerFactory.getLogger(TokenCacheService.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Value("${countryside.eventwrite.token}")
    private String qztoken;

    @Value("${countryside.eventwrite.expiretoken}")
    private String expiretoken;

    @Value("${countryside.appid}")
    private String appid;

    @Value("${countryside.appsecret}")
    private String appsecret;

    @Value("${countryside.tokenurl}")
    private String tokenurl;


    public String   keepAlive() {
        try {
            String tokencache = stringRedisTemplate.opsForValue().get(qztoken);
            if (tokencache != null) {
                //判断是否过期
                String datetime=stringRedisTemplate.opsForValue().get(expiretoken);
                if( null!=datetime){
                    //预留1分钟过期时间
                    Long expireminiseconds =Long.parseLong(datetime);
                    if(new Date().getTime()<expireminiseconds)
                    {
                        return tokencache;
                    }
                }
                return loginServer();
            } else {
                return  loginServer();
            }
        } catch (Exception e) {
            System.out.println(e.toString());
        }
        return null;
    }


    private String loginServer() {
        HttpHeaders headers = getHttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        RestTemplate client = new RestTemplate();
        ResponseEntity<String> response = client.getForEntity((tokenurl+"?appid="+appid+"&appsecret="+appsecret),String.class);
        return getTokenData(response);
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        return headers;
    }
    private String getTokenData(ResponseEntity<String> response){
        try {
            if (response != null && response.getBody() != null && response.getBody().contains("code")) {
                String ret = response.getBody();
                Map map=  new ObjectMapper().readValue(ret,Map.class);
                if ( null !=map && null!=map.get("obj") &&("0").equals(map.get("code"))) {
                    Map object=  new  ObjectMapper().readValue(map.get("obj").toString(),Map.class);
                    if(null!=object   && null!=object.get("accessToken")) {
                        Long  time=Long.parseLong(object.get("expire").toString())-new Date().getTime();
                        stringRedisTemplate.opsForValue().set(expiretoken,time.toString(),time,TimeUnit.MILLISECONDS);
                        stringRedisTemplate.opsForValue().set(qztoken, String.valueOf(object.get("accessToken")),  time,TimeUnit.MILLISECONDS);
                        return String.valueOf(object.get("accessToken"));
                    }
                } else {
                    log.error("getTokenData error :" + response.getBody());
                }
            } else {
                log.error("getTokenData empty...");
            }
        }catch (Exception e){
            System.out.println(e.toString());
            log.error(e.getMessage());
        }
        return null;
    }
}

