package com.cx.cn.cxquartz.redis;

import com.cx.cn.cxquartz.bean.QuartzTaskInformations;
import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.service.quartz.SbtdspsrService;
import com.cx.cn.cxquartz.service.quartz.impl.VideoRTSPorURLService;
import com.cx.cn.cxquartz.util.HttpClientUtil;
import com.cx.cn.cxquartz.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.*;

@Component
public class OrderConsumer implements  Consumer {
    public static final Logger log = LoggerFactory.getLogger(OrderConsumer.class);
    @Value("${local.czurl}")
    private String czurl;
    @Value("${local.fxurl}")
    private String fxurl;
    @Value("${file.recogurl}")
    private String recogurl;
    @Value("${file.model}")
    private String model;
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private  VideoRTSPorURLService videoRTSPorURLService;

    @Autowired
    private  SbtdspsrService sbtdspsrService;


    private static OrderConsumer orderConsumer;
    @PostConstruct
    public void init() {
        orderConsumer = this;
        orderConsumer.rabbitTemplate = this.rabbitTemplate;
        orderConsumer.czurl=this.czurl;
        orderConsumer.fxurl=this.fxurl;
        orderConsumer.recogurl=this.recogurl;
        orderConsumer.model=this.model;
        orderConsumer.videoRTSPorURLService=this.videoRTSPorURLService;
        orderConsumer.sbtdspsrService=this.sbtdspsrService;
    }
    public OrderConsumer(){
    }

    @Override
    public void consume(Object message) {
        if(message instanceof QuartzTaskInformations){
            QuartzTaskInformations msg =(QuartzTaskInformations) message;
            try {
                //调用抽帧服务
                String  devicecode=msg.getExecuteparamter();
                log.info("开始消费消息{}", msg.getId());
                //如果设备编号是用一次废一次的，此刻需要现场取得rtsp
                if(null!=devicecode&&devicecode.startsWith("33") && devicecode.length()==18){
                    //调用抽帧服务
                   String token= orderConsumer.videoRTSPorURLService.getRTSPAccessToekenByDeviceCode(devicecode);
                   String rtsp=orderConsumer.videoRTSPorURLService.getRTSPByDeviceCode(token,devicecode);
                }
                else{
                    //取表里最新的rtsp 或者hls 的值
                    String rtsp=orderConsumer.sbtdspsrService.getRtspOrHLSByDeviceCode(devicecode);
                }
                //将rtsp 作为参数调用抽帧服务
                 String  result="{\n" +
                         "    \"ret\": 0,\n" +
                         "    \"desc\": \"succ!\",\n" +
                         "    \"url\": \"http://zjh189.ncpoi.cc:7080/download/202109/08/33050300001327599605/33050300001327599605_20210908_134131031.jpg\",\n" +
                         "    \"localuri\": \"/home/ubuntu/pictures/slice/202109/08/33050300001327599605/33050300001327599605_20210908_134131031.jpg\",\n" +
                         "    \"timestamp\": \"2021-09-08 13:41:31.031\",\n" +
                         "    \"devicecode\": \"33050300001327599605\"\n" +
                         "}";
                //抽帧结果放到rabbttmq 中，根据msg 的检测metatype ,分别派发到不同的queue中，方便以后10条10条的去皮皮昂分析
                Map m = new HashMap();
                m.put("taskparam", JsonUtil.objToStr(msg));
                m.put("result", result);
                String msgId = UUID.randomUUID().toString();
                CorrelationData correlationData = new CorrelationData(msgId);
                orderConsumer.rabbitTemplate.convertAndSend(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getExchange(),
                        QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey()+"_"+msg.getObjectType(),
                        MessageHelper.objToMsg(m),
                        correlationData);

//                  String roistr= URLEncoder.encode("[")+msg.getObjectx()+","+msg.getObjecty()+","+msg.getObjectw()+","+msg.getObjecth()+URLEncoder.encode("]");
//                String result= CompletableFuture.supplyAsync(() -> HttpClientUtil.doGet(orderConsumer.recogurl + "?deviceCode="+msg.getExecuteparamter()+"&model="+orderConsumer.model+"&roi="+roistr)).get(2, TimeUnit.SECONDS);


//                String roistr= URLEncoder.encode("[")+msg.getObjectx()+","+msg.getObjecty()+","+msg.getObjectw()+","+msg.getObjecth()+URLEncoder.encode("]");
////                String result= CompletableFuture.supplyAsync(() -> HttpClientUtil.doGet(orderConsumer.recogurl + "?deviceCode="+msg.getExecuteparamter()+"&model="+orderConsumer.model+"&roi="+roiarray)).get(2, TimeUnit.SECONDS);
//                log.info(" deviceCode:{} ",msg.getExecuteparamter());
//                String result = HttpClientUtil.doGet(orderConsumer.recogurl + "?deviceCode=" + msg.getExecuteparamter() + "&model=" + orderConsumer.model + "&roi=" + roistr);
//                log.info(" picture result:{} ",result);
//                if (null != result && result.contains("ret"))//放入rabbitmq.数据由消费者去处理
//                {
//                    Map objresult = JsonUtil.strToObj(result, Map.class);
//                    //处理消息
//                    if (null != objresult.get("ret") && objresult.get("ret").toString().equals("0")
//                            && null != objresult.get("desc")
//                            && objresult.get("desc").toString().contains("succ")) {
//                        Map m = new HashMap();
//                        m.put("task", JsonUtil.objToStr(msg));
//                        m.put("result", result);
//                        String msgId = UUID.randomUUID().toString();
//                        CorrelationData correlationData = new CorrelationData(msgId);
//                        //根绝不同的检测事件对象metatype分发到不同的通道
//
//                        orderConsumer.rabbitTemplate.convertAndSend(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getExchange(),
//                                QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey(),
//                                MessageHelper.objToMsg(m),
//                                correlationData);
//                    }
//                }
                //添加具体的消费逻辑，修改数据库什么的
                log.info("消费消息{}完成", msg.getId());
            }catch (Exception ex){
                log.error("消费消息{}error:{}", msg.getId(), ex.toString());
            }
        }
    }
}
