package com.cx.cn.cxquartz.service.quartz;


import com.cx.cn.cxquartz.bean.*;
import com.cx.cn.cxquartz.vo.QuartzTaskRecordsVo;
import org.quartz.SchedulerException;

import java.util.List;
import java.util.Map;

public interface QuartzService {
    String addTask(QuartzTaskInformations quartzTaskInformations);

    List<QuartzTaskInformations> getTaskList(String taskNo, String currentPage);

    QuartzTaskInformations getTaskById(String id);

    String updateTask(QuartzTaskInformations quartzTaskInformations);

    Integer UpdateExecuteParam(Map map);


    String startJob(String taskNo) throws SchedulerException;
    String startOrStopJob(String taskNo,String status) throws SchedulerException;

    void initLoadOnlineTasks();

    void sendMessage(String message);

    QuartzTaskRecords addTaskRecords(String taskNo);

    Integer updateRecordById(Integer count, Long id);

    Integer updateModifyTimeById(QuartzTaskInformations quartzTaskInformations);

    Integer addTaskErrorRecord(String id, String errorKey, String errorValue);

    List<QuartzTaskRecordsVo> taskRecords(String taskNo);

    String runTaskRightNow(String taskNo);

    QuartzTaskErrors detailTaskErrors(String recordId);

    Integer insertRecord(PatrolCtrlRecord record);

    Integer insertAlarm(PatrolCtrlAlarm alarm);

    List<PictureTime> findLastPicTime();

    List< PatrolCtrlRecord> queryCameraCode(List<String> ids);

    List<QuartzTaskInformations> getTaskSByDeviceCode(String devicecode);

    Integer deletetask(String taskno);
}
