package com.cx.cn.cxquartz.rabbitmq.comsumer.listener;

import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.rabbitmq.comsumer.BaseConsumer;
import com.cx.cn.cxquartz.rabbitmq.comsumer.BaseConsumerProxy;
import com.cx.cn.cxquartz.rabbitmq.comsumer.SnapShotConsumer;
import com.cx.cn.cxquartz.service.quartz.TraffPictureService;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 任务消息监听接受器
 */
@Component
public class SnapShotReceiver {
    private static final Logger logger = LoggerFactory.getLogger(SnapShotReceiver.class);
    @Autowired
    private SnapShotConsumer snapShotConsumer;

    @Autowired
    private TraffPictureService traffPictureService;

    @RabbitListener(queues = QueueConstants.QueueRTSPConsumer.QUEUE)
    public void process(Message message, Channel channel) {
        try {
            logger.info("consumer->OrderCancelReceiver消费者收到消息  : " + message.toString());
            BaseConsumerProxy baseConsumerProxy = new BaseConsumerProxy(snapShotConsumer, traffPictureService);
            BaseConsumer proxy = (BaseConsumer) baseConsumerProxy.getProxy();
            if (null != proxy) {
                proxy.consume(message, channel);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
