package com.cx.cn.cxquartz.rabbitmq.comsumer;


import com.cx.cn.cxquartz.service.quartz.TraffPictureService;
import com.cx.cn.cxquartz.service.quartz.impl.ResultService;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.beans.factory.annotation.Autowired;

import java.lang.reflect.Proxy;
import java.util.Map;

public class BaseConsumerProxy {
    private static final Logger logger = LoggerFactory.getLogger(BaseConsumerProxy.class);
    /**
     * 代理对象
     */
    private Object target;

    /**
     * 消息业务操作对象
     */
    @Autowired
    TraffPictureService traffPictureService;

    @Autowired
    ResultService resultService;

    public BaseConsumerProxy(Object target, TraffPictureService traffPictureService) {
        this.target = target;
        this.traffPictureService = traffPictureService;
    }
    public BaseConsumerProxy(Object target) {
        this.target = target;
    }
    /**
     * 使用动态代理实现消费端幂等性验证和消费确认(ack)
     *
     * @return
     */
    public Object getProxy() {
        ClassLoader classLoader = target.getClass().getClassLoader();
        Class[] interfaces = target.getClass().getInterfaces();
        return Proxy.newProxyInstance(classLoader, interfaces, (proxy, method, args) -> {
            Message message = (Message) args[0];
            Channel channel = (Channel) args[1];
            MessageProperties properties = message.getMessageProperties();
            long tag = properties.getDeliveryTag();
            try {
                Object result = method.invoke(target, args);
                // 手动ack
                channel.basicAck(tag, false);
                return result;
            } catch (Exception e) {
                logger.error("getProxy error", e);
                channel.basicNack(tag, false,true);
                return null;
            }
        });
    }


    /**
     * 获取CorrelationId
     *
     * @param message
     * @return
     */
    private String getCorrelationId(Message message) {
        String correlationId = null;
        MessageProperties properties = message.getMessageProperties();
        Map<String, Object> headers = properties.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            String key = (String) entry.getKey();
            String value = (String) entry.getValue();
            if (key.equals("spring_returned_message_correlation")) {
                correlationId = value;
            }
        }
        return correlationId;
    }
}