package com.cx.cn.cxquartz.rabbitmq.comsumer;

import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.service.quartz.TraffAlarmRecordService;
import com.cx.cn.cxquartz.service.quartz.impl.TaskRecog;
import com.cx.cn.cxquartz.util.CommonUtil;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Ϣ͵
 */
@Component
public class TaskQSTConsumer{

    private List<Map> list=new ArrayList<>();


    private static final Logger logger = LoggerFactory.getLogger(TaskQSTConsumer.class);
    @Autowired
    TraffAlarmRecordService traffAlarmRecordService;

    @Autowired
    TaskRecog taskRecog;


    @Value("${voice.unionId}")
    private String unionId;

    @Value("${voice.appKey}")
    private String appKey;

    @Value("${voice.corpId}")
    private String corpId;

    @Value("${voice.eventId}")
    private Integer eventId;
    /**
     * Ϣ
     *
     * @param messageList
     * @param channel
     * @throws IOException
     */
    public void consume(List<Message> messageList, Channel channel) {
        list.clear();
        for (Message message : messageList) {
            Map result = MessageHelper.msgToObj(message, Map.class);
            list.add(result);
        }
        LinkedHashMap<String, List<Map>> maplist = CommonUtil.queryList(list);
        for (String key : maplist.keySet()) {
            try {
                taskRecog.sender(maplist.get(key));
            } catch (Exception ex) {
                logger.error(ex.toString());
            }
        }
    }
}
