package com.cx.cn.cxquartz.controller;


import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.util.*;
import com.cx.cn.cxquartz.vo.*;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import java.io.File;
import java.io.IOException;
import java.util.*;

@RestController
public class AutoSnapController {
    private static final Logger logger = LoggerFactory.getLogger(ExtController.class);

    @Autowired
    RabbitTemplate rabbitTemplate;

    @Value("${snapnote.note1}")
    String note1;

    @RequestMapping(value = "/autoSnap", method = RequestMethod.POST)
    @ResponseBody
    public String AutoSnap(@RequestParam("imageinfo.xml_0") MultipartFile filexml,@RequestParam("vcaimage_0.jpg_1") MultipartFile filejpg    ) {

        logger.info("autosnap  xml:{}",filexml.getName());
        logger.info("autosnap  filejpg:{}",filejpg.getName());
        //        /*ļΪգļ*/
        if (filexml != null && filejpg!= null) {
            //xmlļϢͼƬַϢַϳrabbitmq еĸʽ
            try {
                Document doc= XmlUtils.readDocument(filexml);
                Capture vCACapture=new Capture();
                XmlUtils.parseDocument(vCACapture,doc);
                vCACapture.setDateTime(vCACapture.getDateTime()==null?null:DateUtils.dealDateFormat(vCACapture.getDateTime()));
                //jpg ļļŵĳ·
                String filepath = DateUtils.formatCurrDatefileYMD()  + File.separator + vCACapture.getDeviceId() + File.separator + vCACapture.getDeviceId() + "_" + DateUtils.formatDateToNoSign(vCACapture.getDateTime()) + ".jpg";
                logger.info(filepath);
                //ļcopy·
                File desfile = new File(note1 +File.separator + filepath);
                if (!desfile.getParentFile().exists()) {
                    desfile.getParentFile().mkdirs();
                }
                filejpg.transferTo(desfile);
                Map map=new HashMap<>();
                map.put("resourcePath",filepath);//ӽڵresourcePathĸڵϢֱӽڵϢ
                map.put("timestamp", vCACapture.getDateTime());
                map.put("devicecode", vCACapture.getDeviceId());
                CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
                rabbitTemplate.convertAndSend(QueueConstants.QueueAutoSnapEnum.QUEUE_AUTOSNAP_ENUM.getExchange(),
                        QueueConstants.QueueAutoSnapEnum.QUEUE_AUTOSNAP_ENUM.getRouteKey(),
                        MessageHelper.objToMsg(map),
                        correlationData);
                return "success";
                //ƴΪ¸ʽ
//                    String  result="{\n" +
//                            "    \"ret\": 0,\n" +
//                            "    \"desc\": \"succ!\",\n" +
//                            "    \"url\": \"http://zjh189.ncpoi.cc:7080/download/202109/08/33050300001327599605/33050300001327599605_20210908_134131031.jpg\",\n" +
//                            "    \"resourcePath\": \"/home/ubuntu/pictures/slice/202109/08/33050300001327599605/33050300001327599605_20210908_134131031.jpg\",\n" +
//                            "    \"timestamp\": \"2021-09-08 13:41:31.031\",\n" +
//                            "    \"devicecode\": \"33050300001327599605\"\n" +
//                            "}";
            } catch (IOException e) {
                e.printStackTrace();
                logger.error("IOException",e);
                return "IO error";
            }
        }else{
            logger.error("Ϊnull");
            return "null";
        }
    }
}
