package com.cx.cn.cxquartz.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;



@Configuration
@EnableScheduling
public class ScheduleTaskConfig {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleTaskConfig.class);

    @Autowired
    private RabbitMqService rRabbitMqService;


    @Scheduled(cron = "*/45 * * * * ?")//每隔45s查询所有queue的消费数目，超过警戒值的
    private void statistoday() {
        try {
            int  count= rRabbitMqService.getMessageCount("RabbitMQ.DirectQueue.SendToVoiceConsumer");
            logger.info("count:{}", count);
    }
    catch (Exception ex){

            logger.error(ex.toString());
        }
    }

}
