package com.cx.cn.cxquartz.redis.container;

import com.cx.cn.cxquartz.bean.QuartzTaskInformations;
import com.cx.cn.cxquartz.redis.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

import java.util.concurrent.TimeUnit;

public class QueueListener implements Runnable {
    public static final Logger log = LoggerFactory.getLogger(QueueListener.class);
    private RedisTemplate redisTemplate;

    private String queue;

    private Consumer consumer;

    public QueueListener(RedisTemplate redisTemplate, String queue, Consumer consumer) {
        this.redisTemplate = redisTemplate;
        this.queue = queue;
        this.consumer = consumer;
    }

    /**
     * 使用队列右出获取消息
     * 没获取到消息则线程 sleep 一秒，减少资源浪费
     */
    @Override
    public void run() {
        try {
            while (true) {
                Object message = redisTemplate.opsForList().rightPop(queue);
                if (message instanceof QuartzTaskInformations) {
                    consumer.consume(message);
                } else {
                    try {
                        Thread.sleep(1000);
                    } catch (InterruptedException e) {
                        log.error("RedisMQConsumer error:{}", e.toString());
                    }
                }
            }
        } catch (Exception e) {
            log.error("RedisMQConsumer error:{}", e.toString());
        }
    }
}