package com.cx.cn.cxquartz.rabbitmq.producer.callback;

import com.cx.cn.cxquartz.controller.ExtController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;

/**
 * ϢȷϵĻص
 */
@Component
public class ConsumerConfirmAndReturnCallback implements RabbitTemplate.ConfirmCallback, RabbitTemplate.ReturnCallback {

    private static final Logger logger = LoggerFactory.getLogger(ExtController.class);
    @Autowired
    private RabbitTemplate rabbitTemplate;

    /**
     * PostConstruct: ϵע֮Ҫִеķϣִκγʼ.
     */
    @PostConstruct
    public void init() {
        //ָ ConfirmCallback
        rabbitTemplate.setConfirmCallback(this);
        //ָ ReturnCallback
        rabbitTemplate.setReturnCallback(this);
    }

    /**
     * ϢӽɹУspring.rabbitmq.publisher-returns=true
     */
    @Override
    public void returnedMessage(Message message, int replyCode, String replyText, String exchange, String routingKey) {
        logger.info(" info->" + new String(message.getBody(), StandardCharsets.UTF_8) + ",\n replyCode:" + replyCode
                + "\n replyText:" + replyText + "\n exchange:" + exchange + ",\\n routingKey:" + routingKey);
    }

    /**
     * ϢҲӦExchangeȴ˷
     * Ϣûеｻ,÷isSendSuccess = false,errorΪϢ;
     * Ϣȷｻ,÷isSendSuccess = true;
     * Ҫ confirm ȷϻ
     * spring.rabbitmq.publisher-confirms=true
     */
    @Override
    public void confirm(CorrelationData correlationData, boolean isSendSuccess, String error) {
        if (correlationData != null) {
            if (isSendSuccess) {
                logger.info("confirmص->Ϣɹ͵");
            } else {
                logger.info("confirmص->Ϣ[{}]͵ʧܣԭ : [{}]", correlationData, error);
            }
        }
    }
}
