package com.cx.cn.cxquartz.redis;

import com.cx.cn.cxquartz.bean.QuartzTaskInformations;
import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.service.quartz.SbtdspsrService;
import com.cx.cn.cxquartz.service.quartz.impl.VideoRTSPorURLService;
import com.cx.cn.cxquartz.util.DateUtils;
import com.cx.cn.cxquartz.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.BatchingRabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.PostConstruct;
import java.util.*;

@Component
public class OrderConsumer implements  Consumer {
    public static final Logger log = LoggerFactory.getLogger(OrderConsumer.class);
    @Value("${local.czurl}")
    private String czurl;
    @Value("${local.fxurl}")
    private String fxurl;

    @Value("${file.rootpath}")
    private String czrooturl;


    @Autowired
    private  VideoRTSPorURLService videoRTSPorURLService;

    @Autowired
    private  SbtdspsrService sbtdspsrService;
    @Autowired
    BatchingRabbitTemplate batchQueueRabbitTemplate;

    private static OrderConsumer orderConsumer;
    @Autowired
    private RestTemplate restTemplate;

    @PostConstruct
    public void init() {
        orderConsumer = this;
        orderConsumer.batchQueueRabbitTemplate = this.batchQueueRabbitTemplate;
        orderConsumer.czurl=this.czurl;
        orderConsumer.fxurl=this.fxurl;
        orderConsumer.videoRTSPorURLService=this.videoRTSPorURLService;
        orderConsumer.sbtdspsrService=this.sbtdspsrService;
        orderConsumer.restTemplate=this.restTemplate;
    }
    public OrderConsumer(){
    }

    @Override
    public void consume(Object message) {
        if(message instanceof QuartzTaskInformations){
            QuartzTaskInformations msg =(QuartzTaskInformations) message;
            try {
                //ó֡
                String  devicecode=msg.getExecuteparamter();
                String  rtsporhls="";
                log.info("ʼϢ{}", msg.getId());
                //豸һηһεģ˿Ҫֳȡrtsp
                if(null!=devicecode&&devicecode.startsWith("33") && devicecode.length()!=18){
                    //ó֡
                   String token= orderConsumer.videoRTSPorURLService.getRTSPAccessToekenByDeviceCode(devicecode);
                    rtsporhls=orderConsumer.videoRTSPorURLService.getRTSPByDeviceCode(token,devicecode);
                }
                else{
                    //ȡµrtsp hls ֵ
                    rtsporhls=orderConsumer.sbtdspsrService.getRtspOrHLSByDeviceCode(devicecode);
                }

                if(rtsporhls.equals("")){
                    //³֡һ
                    String token= orderConsumer.videoRTSPorURLService.getRTSPAccessToekenByDeviceCode(devicecode);
                    rtsporhls=orderConsumer.videoRTSPorURLService.getRTSPByDeviceCode(token,devicecode);
                    if(rtsporhls.equals("")) {
                        log.error(devicecode + "rtsp hls ַΪ");
                        return;
                    }
                }
                //rtsp Ϊó֡


//                 String  result="{\n" +
//                         "    \"ret\": 0,\n" +
//                         "    \"desc\": \"succ!\",\n" +
//                         "    \"resourcePath\": \"http://zjh189.ncpoi.cc:7080/download/202109/08/33050300001327599605/33050300001327599605_20210908_134131031.jpg\",\n" +
//                         "    \"localuri\": \"/home/ubuntu/pictures/slice/202109/08/33050300001327599605/33050300001327599605_20210908_134131031.jpg\",\n" +
//                         "    \"timestamp\": \"2021-09-08 13:41:31.031\",\n" +
//                         "    \"devicecode\": \"33050300001327599605\"\n" +
//                         "}";
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                Map map=new HashMap();
                map.put("resourcePath",orderConsumer.czrooturl+"/"+ DateUtils.formatCurrDatefileYMD()+"/"+devicecode+"/"+devicecode+"_"+DateUtils.formatCurrDayNoSign()+"_"+DateUtils.formatCurrDateHHmmss()+".jpg");
                map.put("deviceID",devicecode);
                map.put("resourceParam",rtsporhls);
               HttpEntity<Map> requestEntity = new HttpEntity<>(map, headers);
                log.info("֡:{}",JsonUtil.objToStr(map));
                Map resultmap= orderConsumer.restTemplate.postForObject(orderConsumer.czurl,requestEntity, Map.class);
               if(null!=resultmap.get("ret")) {
                    if (resultmap.get("ret").toString().equals("0")
                            && null!=resultmap.get("resourcePath")
                            && !resultmap.get("resourcePath").toString().equals("")) {
                        //֡ŵrabbttmq Уmsg ļmetatype ,ֱɷͬqueueУԺ1010ȥƤƤ
                        Map m = new HashMap();
                        m.put("task", JsonUtil.objToStr(msg));
                        m.put("result", JsonUtil.objToStr(resultmap));
                        CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
                        orderConsumer.batchQueueRabbitTemplate.send(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getExchange(),
                                QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey() + "_QST",
                                MessageHelper.objToMsg(m),
                                correlationData);
                    }
                    else{
                        log.error("֡ʧ:{}",JsonUtil.objToStr(resultmap));
                    }
                }
                else{

                    log.error("״̬Ϊnull");

                }
//                  String roistr= URLEncoder.encode("[")+msg.getObjectx()+","+msg.getObjecty()+","+msg.getObjectw()+","+msg.getObjecth()+URLEncoder.encode("]");
//                String result= CompletableFuture.supplyAsync(() -> HttpClientUtil.doGet(orderConsumer.recogurl + "?deviceCode="+msg.getExecuteparamter()+"&model="+orderConsumer.model+"&roi="+roistr)).get(2, TimeUnit.SECONDS);


//                String roistr= URLEncoder.encode("[")+msg.getObjectx()+","+msg.getObjecty()+","+msg.getObjectw()+","+msg.getObjecth()+URLEncoder.encode("]");
////                String result= CompletableFuture.supplyAsync(() -> HttpClientUtil.doGet(orderConsumer.recogurl + "?deviceCode="+msg.getExecuteparamter()+"&model="+orderConsumer.model+"&roi="+roiarray)).get(2, TimeUnit.SECONDS);
//                log.info(" deviceCode:{} ",msg.getExecuteparamter());
//                String result = HttpClientUtil.doGet(orderConsumer.recogurl + "?deviceCode=" + msg.getExecuteparamter() + "&model=" + orderConsumer.model + "&roi=" + roistr);
//                log.info(" picture result:{} ",result);
//                if (null != result && result.contains("ret"))//rabbitmq.ȥ
//                {
//                    Map objresult = JsonUtil.strToObj(result, Map.class);
//                    //Ϣ
//                    if (null != objresult.get("ret") && objresult.get("ret").toString().equals("0")
//                            && null != objresult.get("desc")
//                            && objresult.get("desc").toString().contains("succ")) {
//                        Map m = new HashMap();
//                        m.put("task", JsonUtil.objToStr(msg));
//                        m.put("result", result);
//                        String msgId = UUID.randomUUID().toString();
//                        CorrelationData correlationData = new CorrelationData(msgId);
//                        //ͬļ¼metatypeַͬͨ
//
//                        orderConsumer.rabbitTemplate.convertAndSend(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getExchange(),
//                                QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey(),
//                                MessageHelper.objToMsg(m),
//                                correlationData);
//                    }
//                }
                //Ӿ߼޸ݿʲô
            }catch (Exception ex){
                log.error("Ϣ{}error:{}", msg.getId(), ex.toString());
            }
        }
    }
}
