package com.cx.cn.cxquartz.util;

import com.cx.cn.cxquartz.vo.Capture;
import com.thoughtworks.xstream.XStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.*;

public class XmlUtils {

    private static final Logger logger = LoggerFactory.getLogger(XmlUtils.class);
    private static final String UTF_8 = "UTF-8";
    private static final String XML_HEAD = "<?xml version=\"1.0\" encoding=\"%s\"?>";
    private static final String SPACE = "";
    private static final String LEFT_ANGLE = "<";
    private static final String RIGHT_ANGLE = ">";
    private static final String LEFT_SLASH_ANGLE = "</";
    private static final String SET = "set";
    private static final String GET = "get";
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String POINT_JAVA = "java.";
    private static final String DATE = "java.util.Date";
    private static final String LONG = "java.lang.Long";
    private static final String INTEGER = "java.lang.Integer";
    private static final String DOUBLE = "java.lang.Double";
    private static final String FLOAT = "java.lang.Float";
    private static final String LIST = "java.util.List";
        private XmlUtils() {
        }

        /**
         * 序列化XML
         *
         * @param obj
         * @return
         */
        public static <T> String toXML(Object obj) {
            XStream stream = getXStream();
            stream.processAnnotations(obj.getClass());
            return new StringBuffer(XML_HEAD).append(stream.toXML(obj)).toString();
        }

        /**
         * 反序列化XML
         *
         * @param xmlStr
         * @param clazz
         * @return
         */
        public static <T> T fromXML(String xmlStr, Class<T> clazz) {
            XStream stream = getXStream();
            stream.processAnnotations(clazz);
            Object obj = stream.fromXML(xmlStr);
            try {
                return clazz.cast(obj);
            } catch (ClassCastException e) {
                return null;
            }
        }

        /**
         * 获取指定节点的值
         *
         * @param xpath
         * @param dataStr
         * @return
         */
        public static String getNodeValue(String xpath, String dataStr) {
            try {
                // 将字符串转为xml
                Document document = DocumentHelper.parseText(dataStr);
                // 查找节点
               Element element = (Element) document.selectSingleNode(xpath);
                if (element != null) {
                    return element.getStringValue();
                }
            } catch (org.dom4j.DocumentException e) {
                e.printStackTrace();
            }
            return "";
        }

        /**
         * 获取Xstream实例
         *
         * @return
         */
        public static XStream getXStream() {
            return new XStream();
        }


    public static  Capture parseDocument(Capture obj, Document doc)
    {   Element rootElement = doc.getRootElement();
        for (Iterator<Element> iters = rootElement.elementIterator(); iters.hasNext(); ) {
            Element element = iters.next();
            String elementName = element.getName();
            if(elementName.equalsIgnoreCase("deviceId")){
                obj.setDeviceId(element.getStringValue());
                logger.info("deviceId:{}",element.getStringValue());
            }
            for (Iterator<Element> iter = element.elementIterator(); iter.hasNext(); ) {
                Element elementiter = iter.next();
                for (Iterator<Element> iterchilsthree = elementiter.elementIterator(); iterchilsthree.hasNext(); ) {
                    Element elementchilsthree = iterchilsthree.next();
                    if(elementchilsthree.getName().equalsIgnoreCase("datetime"))
                    {
                        obj.setDateTime(elementchilsthree.getStringValue());
                        logger.info("datetime:{}",elementchilsthree.getStringValue());
                    }
                }
            }
        }
        return obj;
    }

    private static Map<String, Field> buildDataMapper(Field[] fields){
        Map<String, Field> mappers = new HashMap<String, Field>(16);
        for (Field field : fields) {
            if (!Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers())){
                if (field.isAnnotationPresent(DomFieldIngore.class)) {
                    continue;
                }
                String fieldName = null;
                if (field.isAnnotationPresent(DomField.class)) {
                    DomField domField = field.getAnnotation(DomField.class);
                    if (!SPACE.equals(domField.value())) {
                        fieldName = domField.value();
                    }
                }

                if (fieldName == null) {
                    fieldName = field.getName();
                }
                mappers.put(fieldName, field);
            }
        }
        return mappers;
    }

    /**
     * 获取根名称
     *
     * @param clazz clazz
     * @return String
     */
    private static <T> String getRootName(Class<T> clazz) {
        String rootName = null;
        if (clazz.isAnnotationPresent(DomRoot.class)) {
            DomRoot domRoot = clazz.getAnnotation(DomRoot.class);
            if (!SPACE.equals(domRoot.value())) {
                rootName = domRoot.value();
            }
        } else {
            rootName = clazz.getSimpleName();
        }
        return rootName;
    }

    /**
     * 将对象转成xml
     *
     * @param t        t
     * @param encoding 编码
     * @return String
     */
    public static <T> String beanToXml(T t, String encoding, boolean xmlHead, boolean xmlRoot, boolean xmlField) {
        StringBuffer sb = new StringBuffer();
        try {
            if (xmlHead) {
                sb.append(String.format(XML_HEAD,encoding));
            }
            Class<?> clazz = t.getClass();
            String rootName = getRootName(clazz);
            if (xmlRoot) {
                sb.append(LEFT_ANGLE);
                sb.append(rootName);
                sb.append(RIGHT_ANGLE);
            }
            // 获取所有属性
            Field[] fields = clazz.getDeclaredFields();
            buildXmlUseFields(t, sb, clazz, fields, xmlField);
            if (xmlRoot) {
                sb.append(LEFT_SLASH_ANGLE);
                sb.append(rootName);
                sb.append(RIGHT_ANGLE);
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return sb.toString();
    }

    private static <T> void buildXmlUseFields(T t, StringBuffer sb, Class<?> clazz, Field[] fields, boolean xmlFullField)
            throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Map<String, Field> mappers = buildDataMapper(fields);
        for (Map.Entry<String, Field> entry : mappers.entrySet()) {
            String key = entry.getKey();
            Field field = entry.getValue();
            String getMethodName = GET + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            Method getMethod = clazz.getMethod(getMethodName);
            Object value = getMethod.invoke(t);
            if (xmlFullField) {
                sb.append(LEFT_ANGLE);
                sb.append(key);
                sb.append(RIGHT_ANGLE);
            } else {
                if (value != null && value != "") {
                    sb.append(LEFT_ANGLE);
                    sb.append(key);
                    sb.append(RIGHT_ANGLE);
                }
            }
            if (field.getType().getName().startsWith(POINT_JAVA) && !LIST.equals(field.getType().getName())) {
                if (field.getType().getName().equals(DATE) && value != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
                    sb.append(sdf.format(value));
                } else if (value != null) {
                    sb.append(value);
                }
            } else if (LIST.equals(field.getType().getName())) {
                List list = (List) value;
                for (Object obj : list) {
                    Class<?> objClass = obj.getClass();
                    String rootName = getRootName(objClass);
                    sb.append(LEFT_ANGLE);
                    sb.append(rootName);
                    sb.append(RIGHT_ANGLE);
                    buildXmlUseFields(obj, sb, objClass, objClass.getDeclaredFields(), xmlFullField);
                    sb.append(LEFT_SLASH_ANGLE);
                    sb.append(rootName);
                    sb.append(RIGHT_ANGLE);
                }
            } else {
                Class<?> type = field.getType();
                buildXmlUseFields(value, sb, type, type.getDeclaredFields(), xmlFullField);
            }
            if (xmlFullField) {
                sb.append(LEFT_SLASH_ANGLE);
                sb.append(key);
                sb.append(RIGHT_ANGLE);
            } else {
                if (value != null && value != SPACE) {
                    sb.append(LEFT_SLASH_ANGLE);
                    sb.append(key);
                    sb.append(RIGHT_ANGLE);
                }
            }
        }
    }

    public static <T> String beanToXml(T t, boolean xmlHead, boolean xmlRoot, boolean xmlFullField) {
        return beanToXml(t, UTF_8, xmlHead, xmlRoot, xmlFullField);
    }

    public static Document readDocument (MultipartFile multipartFile)    {
        InputStream inputStream= null;
        try {
            inputStream = multipartFile.getInputStream();
        } catch (IOException e) {
            e.printStackTrace();
        }
        File file= new File(multipartFile.getOriginalFilename());
        try {
            inputStreamTofile(inputStream,file);
        } catch (IOException e) {
            e.printStackTrace();
        }
        try {
            inputStream.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        SAXReader reader = new SAXReader();
        Document  document = null;
        try {
            document = reader.read(file);
        } catch (DocumentException e) {
            e.printStackTrace();
        }
        return document;
    }

   public  static void inputStreamTofile(InputStream inputStream,File file) throws IOException {
       OutputStream outputStream = null;
       try {
           outputStream = new FileOutputStream(file);
       } catch (FileNotFoundException e) {
           e.printStackTrace();
       }
       int byteread = 0;
       byte[] buffer = new byte[1024];
       while ((byteread = inputStream.read(buffer, 0, buffer.length)) != -1) {
           try {
               outputStream.write(buffer, 0, byteread);
           } catch (IOException e) {
               e.printStackTrace();
           }
       }
       try {
           outputStream.close();
           inputStream.close();
       } catch (IOException e) {
           e.printStackTrace();
       }
   }
   }