package com.cx.cn.cxquartz.util;


import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CommonUtil {

    /**
     * 获取具体的异常信息
     *
     * @param ex
     * @return
     */
    public static String getExceptionDetail(Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            ex.printStackTrace(pw);
            return sw.toString();
        } finally {
            pw.close();
        }
    }

    public static LinkedHashMap<String, List<Map>> queryList(List<Map> list) {
        LinkedHashMap<String, List<Map>> map = new LinkedHashMap<>();
        for (Map li : list) {
            //将需要归类的属性与map中的key进行比较，如果map中有该key则添加bean如果没有则新增key
            Map mapresult = JsonUtil.strToObj(li.get("task").toString(), Map.class);
            if (map.size() > 0 && null != mapresult.get("objectType") && map.containsKey(mapresult.get("objectType").toString())) {
                //取出map中key对应的list并将遍历出的bean放入该key对应的list中
                ArrayList<Map> templist = (ArrayList<Map>) map.get(mapresult.get("objectType"));
                templist.add(li);
            } else {
                //创建新的list
                ArrayList<Map> temlist = new ArrayList<Map>();
                temlist.add(li);
                map.put(mapresult.get("objectType").toString(), temlist);
            }
        }
        return map;
    }

}
