package com.cx.cn.cxquartz.rabbitmq.comsumer;

import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.service.quartz.TraffAlarmRecordService;
import com.cx.cn.cxquartz.service.quartz.impl.EventWriteService;
import com.cx.cn.cxquartz.util.JsonUtil;
import com.cx.cn.cxquartz.vo.JobTjParam;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Map;

/**
 * 消息处理并推送第三方
 */
@Component
public class SendToDXConsumer implements BaseConsumer {
    private static final Logger logger = LoggerFactory.getLogger(SendToDXConsumer.class);
    @Autowired
    TraffAlarmRecordService traffAlarmRecordService;

    @Autowired
    EventWriteService eventWriteService;
    /**
     * 消息消费入口
     *
     * @param message
     * @param channel
     * @throws IOException
     */
    @Override
    public void consume(Message message, Channel channel) throws IOException {
        logger.info("SendToDXConsumer 收到消息: {}", message.toString());
        Map result = MessageHelper.msgToObj(message, Map.class);
        if (null != result.get("id") && null!=result.get("traff") && null!=result.get("callback")) {
            JobTjParam jobTjParam=JsonUtil.strToObj(result.get("traff").toString(),JobTjParam.class);
            if(null!=jobTjParam) {
            eventWriteService.sendEventByCallUrl(Long.parseLong(result.get("id").toString())
                    , jobTjParam, result.get("callback").toString());
            }
        }
    }
}
