package com.cx.cn.cxquartz.config;


import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class getSnapShotConfig {
    /**
     * 创建交换机
     *
     * @return
     */
    @Bean
    public DirectExchange RTSPDirectExchange() {
        return new DirectExchange(QueueConstants.QueueRTSPEnum.QUEUE_RTSP_ENUM.getExchange());
    }

    /**
     * 创建队列 true表示是否持久
     *
     * @return
     */
    @Bean
    public Queue RTSPDirectQueue() {
        return new Queue(QueueConstants.QueueRTSPEnum.QUEUE_RTSP_ENUM.getQueue(), true);
    }

    /**
     * 将队列和交换机绑定,并设置用于匹配路由键
     *
     * @return
     */
    @Bean
    public Binding BindingRTSPDirect() {
        return BindingBuilder.bind(RTSPDirectQueue()).to(RTSPDirectExchange()).with(QueueConstants.QueueRTSPEnum.QUEUE_RTSP_ENUM.getRouteKey());
    }
}