package com.cx.cn.cxquartz.config;


import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 处理图片分析结果的队列
 */
@Configuration
public class EventProcessingConfig {
    /**
     * 创建交换机
     *
     * @return
     */
    @Bean
    public DirectExchange EventProcessingDirectExchange() {
        return new DirectExchange(QueueConstants.QueueEventProcessingEnum.QUEUE_EVENT_PROCESSING_ENUM.getExchange());
    }

    /**
     * 创建队列 true表示是否持久
     *
     * @return
     */
    @Bean
    public Queue EventProcessingDirectQueue() {
        return new Queue(QueueConstants.QueueEventProcessingEnum.QUEUE_EVENT_PROCESSING_ENUM.getQueue(), true);
    }

    /**
     * 将队列和交换机绑定,并设置用于匹配路由键
     *
     * @return
     */
    @Bean
    public Binding EventProcessingDirect() {
        return BindingBuilder.bind(EventProcessingDirectQueue()).to(EventProcessingDirectExchange()).with(QueueConstants.QueueEventProcessingEnum.QUEUE_EVENT_PROCESSING_ENUM.getRouteKey());
    }
}