package com.cx.cn.cxquartz.rabbitmq.comsumer.listener;

import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.rabbitmq.comsumer.AutoSnapConsumer;
import com.cx.cn.cxquartz.rabbitmq.comsumer.BaseConsumer;
import com.cx.cn.cxquartz.rabbitmq.comsumer.BaseConsumerProxy;
import com.cx.cn.cxquartz.service.quartz.TraffPictureService;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 告警信息结果分析
 */
@Component
public class AutoSnapReceiver {
    private static final Logger logger = LoggerFactory.getLogger(AutoSnapReceiver.class);
    @Autowired
    private AutoSnapConsumer autoSnapConsumer;
    @RabbitListener(queues = QueueConstants.QueueAutoSnapConsumer.QUEUE)
    public void process(Message message, Channel channel) {
        try {
            BaseConsumerProxy baseConsumerProxy = new BaseConsumerProxy(autoSnapConsumer);
            BaseConsumer proxy = (BaseConsumer) baseConsumerProxy.getProxy();
            if (null != proxy) {
                proxy.consume(message, channel);
            }
        } catch (Exception e) {
            logger.error("告警信息结果分析 error:{}",e);
        }
    }
}
