package com.cx.cn.cxquartz.controller;


import com.cx.cn.cxquartz.job.WebSocket;
import com.cx.cn.cxquartz.service.quartz.*;
import com.cx.cn.cxquartz.service.quartz.impl.EventWriteService;
import com.cx.cn.cxquartz.util.DateUtils;
import com.cx.cn.cxquartz.util.JsonUtil;
import com.cx.cn.cxquartz.util.RestUtil;
import com.cx.cn.cxquartz.util.ResultUtil;
import com.cx.cn.cxquartz.vo.JobTjParam;
import com.cx.cn.cxquartz.vo.ResultObj;
import com.cx.cn.cxquartz.vo.TraffAlarmRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/ext")
@PropertySource("classpath:file.properties")
public class ExtController {
    private static final Logger logger = LoggerFactory.getLogger(AutoSnapController.class);
    @Value("${file.rtspurl}")
    private String rtspurl;
    @Value("${file.getrtspbyurl}")
    private String getrtspbyurl;
    @Value("${file.publicpictureurl}")
    private String publicpictureurl;

    @Value("${voice.appKey}")
    private String appKey;

    @Value("${voice.corpId}")
    private String corpId;

    @Value("${voice.eventId}")
    private Integer eventId;



    @Value("${voice.unionId}")
    private String unionId;
    @Value("${web.url}")
    private String weburl;

    @Autowired
    TraffAlarmRecordService traffAlarmRecordService;
    @Autowired
    TraffPictureService traffPictureService;
    @Autowired
    PedestrianService pedestrianService;
    @Autowired
    TrafficService trafficService;
    @Autowired
    FaceService faceService;
    @Value("${file.ftppath}")
    private String ftppath;
    @Autowired
    PeopleridebicycService peopleridebicycService;
    @Autowired
    WebSocket webSocket;
    @Autowired
    CodeService codeservice;
    @Autowired
    EventWriteService eventWriteService;
    RestUtil restutil = new RestUtil();

    @Resource
    public void setRestTemplate(RestTemplate restTemplate) {
        restutil.restTemplate = restTemplate;
    }

    @Resource
    public void setSbtdspsrService(SbtdspsrService sbtdspsrService) {
        restutil.sbtdspsrService = sbtdspsrService;
    }

    @RequestMapping(value = "/getRTSP/{photonum}", method = RequestMethod.POST)
   public String getrtsp(@RequestBody String videoid,
                          @PathVariable("photonum") Integer photonum) {
        //ԳȡһͼƬ
        List<String> imgUrls = new ArrayList<>();
        TraffAlarmRecord traffAlarmRecord = new TraffAlarmRecord();
        try {
            logger.info("rtspurl" + rtspurl);
            String timestamp = restutil.getPicture(imgUrls, videoid, rtspurl,traffAlarmRecord);
            logger.info("timestamp" + timestamp);
            if(null==timestamp){
                logger.info("getRTSP/1 no snapshot");
                return ResultUtil.success();
            }
            if (timestamp.contains(".")) {
                traffAlarmRecord.setCreatetime(timestamp.split("\\.")[0]);
            } else {
                traffAlarmRecord.setCreatetime(timestamp);
            }
        } catch (Exception ex) {
            logger.info("getRTSP/1 error:{}", ex.toString());
            traffAlarmRecord.setCreatetime(DateUtils.formatCurrDate());
        }
        try {
            if (imgUrls.size() == 0) {
                restutil.getPicture(imgUrls, videoid, rtspurl,traffAlarmRecord);
            }

            traffAlarmRecord.setFdid(videoid);
            traffAlarmRecord.setChannelid(0);
            traffAlarmRecord.setAreaid(Long.parseLong("-1"));
            traffAlarmRecord.setPushstatus(9);
            //
            traffAlarmRecord.setCheckstatus(9);
            //δȡ
            traffAlarmRecord.setProcessstatus("-2");
            traffAlarmRecord.setImg1urlfrom(imgUrls.get(0));
            //첽
            traffAlarmRecordService.inserTraffAlarmRecord(traffAlarmRecord);
            return ResultUtil.success();
        } catch (Exception e) {
            logger.error("ext/getRTSPr-->error:{}" + e.toString());
        }
        return ResultUtil.success();
    }

//
//    @RequestMapping(value = "/getDeviceSnapshotAndRecognize", method = RequestMethod.POST)
//    public String getDeviceSnapshotAndRecognize(@RequestBody String taskno) {
//        //жϼǷڣüؼ¼ʲô
//        List<QuartzTaskInformations> mapList = sbtdspsrService.selectRecogByRtsp(taskno);
//        String model = "1";
//        //ͼƬѡķΧ
//        Long[] roiarray;
//        HttpEntity<GoalStructureParam> requestEntity = null;
//        if (null != mapList && !mapList.equals("") && mapList.size() > 0) {
//
//            HttpHeaders headers = new HttpHeaders();
//            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
//            Map<String, Object> mapparam = new HashMap<>();
//            roiarray = new Long[4];
//
//            //øüصļҵⷶΧ
//            for (QuartzTaskInformations taskinfo : mapList) {
//                roiarray[0] = new Long(taskinfo.getObjectx());
//                roiarray[1] = new Long(taskinfo.getObjecty());
//                roiarray[2] = new Long(taskinfo.getObjectw());
//                roiarray[3] = new Long(taskinfo.getObjecth());
//                String devicecode=taskinfo.getExecuteparamter();
//                //ѯü滹ûо
//                Map<String, Object> map = new HashMap<>();
//                map.put("sbbh", devicecode);
//                map.put("recordtype", taskinfo.getRecordtype());
//
//                List<TraffAlarmRecord> traffalarmrecordlist=traffAlarmRecordService.getTraffAlarmRecordByProgress(map);
//                if(traffalarmrecordlist.size()<1) {
//                    return ResultUtil.success();
//                }
//                for (TraffAlarmRecord transferRecord : traffalarmrecordlist) {
//                    GoalStructureParam param = FileTransferManager.getGoalStructureParam(roiarray,
//                            Integer.parseInt(model == null ? "1" : "".equals(model) ? "1" : model),2, transferRecord);
//                    if (param.getImageList().size() < 1) {
//                        logger.info(" no  imagelist ");
//                        continue;
//                    }
//                    String maprecogdata = restTemplate.postForObject(recogurl, param, String.class);
//                    try {
//                            Map result = new ObjectMapper().readValue(maprecogdata, Map.class);
//                     if (null != result.get("ret") && result.get("ret").equals("200")) {
//                         //Ϊѷ
//                         transferRecord.setProcessstatus("-1");
//                         traffAlarmRecordService.updateTraffAlarmRecordProcess(transferRecord);
//                         String recordtype = taskinfo.getRecordtype();
//                         JobTjParam jobTjParam = new JobTjParam();
//                         jobTjParam.setDeviceId(devicecode);
//                         jobTjParam.setDetectType(recordtype);
//                         String imageurl = transferRecord.getImg1path();
//                         List<Map> points = new ArrayList<>();
//                         //
//                         List<Map> objectresult = (List<Map>) result.get("ObjectList");
//                         if (objectresult.size() < 1) {
//                             logger.info("  objectresult is empty");
//                             continue;
//                         }
//                         //õλ
//                         logger.info("õλ");
//                         TraffpictureParam traffpictureParamresult = new TraffpictureParam();
//                          traffpictureParamresult = eventWriteService.getResult(traffpictureParamresult,Integer.parseInt(taskinfo.getMetatype())
//                                 , roiarray, imageurl, objectresult, jobTjParam, points);
//                        if(null==traffpictureParamresult){
//                            logger.info("ȺܶδĿδ");
//                            continue;
//                        }
//                         eventWriteService.setTraffpictureParam(recordtype, devicecode,
//                                 transferRecord.getCreatetime(),
//                                 traffpictureParamresult);
//                         //ͼƬ߲ϴ
//                         logger.info("ͼƬ߲ϴ");
//                         String basepath = DateUtils.formatCurrDayYM() +
//                                 File.separator + DateUtils.formatCurrDayDD() + File.separator +
//                                 devicecode;
//                         String filename = devicecode + "_" + DateUtils.parseDateToStrNoSign(transferRecord.getRecordtime()) +"_"+ recordtype+"_result.jpg";
//                         eventWriteService.uploadPicture(traffpictureParamresult, transferRecord.getImg1urlfrom(), points, basepath, filename);
//                         String filenameurl = File.separator + outpath + File.separator + basepath + File.separator + filename;
//                         jobTjParam.setImageUrl(weburl + filenameurl);
//                            logger.info("file path:{}",filenameurl);
//                         traffpictureParamresult.setImagedata(filenameurl);
//                         traffpictureParamresult.setProcessstatus("-1");
//                         traffPictureService.updateTraffpicture(traffpictureParamresult);
//
//                         //ص
//                            logger.info("send to dianxin data:{}",jobTjParam.toString());
//                         eventWriteService.sendEventByCallUrl(traffpictureParamresult, jobTjParam, taskinfo.getUrl().equals("") ? callbackurl : taskinfo.getUrl());
//
//                         if (unionId.contains(devicecode)) {
//                             VoiceData voicedata = new VoiceData();
//                             voicedata.setAppKey(appKey);
//                             voicedata.setCorpId(corpId);
//                             Voice voice = new Voice();
//                             voice.setEventId(eventId);
//                             voice.setUnionId(unionId);
//                             voicedata.setRequestData(voice);
//                             // logger.info(" send to  voice: {}", new ObjectMapper().writeValueAsString(voicedata));
//                             eventWriteService.sendVoice(voicedata);
//                         }
//                         //͸澯ǰ
//                         webSocket.GroupSending(new ObjectMapper().writeValueAsString(traffpictureParamresult));
//                     }
//                        } catch (Exception ex) {
//                        logger.error(ex.toString());
//                        }
//                        //
//                        //getMetaData( objectresult );
//                    }
//                }
//            return ResultUtil.success();
//        } else {
//            logger.info("زڸ÷Χ");
//        }
//        //record Progress ֶΣ0Ϊ δ⣬-2 Ϊʧܣ
//        //жװ
//        return ResultUtil.success();
//    }
//    @RequestMapping(value = "/getDeviceSnapshotAndRecognize", method = RequestMethod.POST)
//    public String getDeviceSnapshotAndRecognize(@RequestBody String taskno) {
//        //жϼǷڣüؼ¼ʲô
//        List<QuartzTaskInformations> mapList = sbtdspsrService.selectRecogByRtsp(taskno);
//        String model = "1";
//        //ͼƬѡķΧ
//        Long[] roiarray;
//        String  devicecode="";
//        if (null != mapList && !mapList.equals("") && mapList.size() > 0) {
//            //ѯü滹ûо
//            //Map<String, Object> map = new HashMap<>();
//            //map.put("sbbh", devicecode);
//
//            HttpHeaders headers = new HttpHeaders();
//            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
//            Map<String, Object> mapparam = new HashMap<>();
//            roiarray = new Long[4];
//            //øüصļҵⷶΧ
//            for (QuartzTaskInformations taskinfo : mapList) {
//                roiarray[0] = new Long(taskinfo.getObjectx());
//                roiarray[1] = new Long(taskinfo.getObjecty());
//                roiarray[2] = new Long(taskinfo.getObjectw());
//                roiarray[3] = new Long(taskinfo.getObjecth());
//                devicecode=taskinfo.getExecuteparamter();
////                roiarray[0] = new Long(0);
////                roiarray[1] = new Long(0);
////                roiarray[2] = new Long(0);
////                roiarray[3] = new Long(0);
//                // for (TraffAlarmRecord transferRecord : traffalarmrecordlist) {
//                mapparam.put("deviceCode", devicecode);
//                mapparam.put("model", model);
//                mapparam.put("roi", roiarray);
////                    logger.info("recogurl="+recogurl);
//                Map objectList = restTemplate.getForObject(recogurl + "?deviceCode={deviceCode}&model={model}&roi={roi}", Map.class, mapparam);
//
//                if (String.valueOf(objectList.get("ret")).equals("0")) {
//                    //Ϊѷ
//                    //   transferRecord.setProcessstatus("-1");
//                    //  traffAlarmRecordService.updateTraffAlarmRecordProcess(transferRecord);
//                    String recordtype=taskinfo.getRecordtype();
//                    JobTjParam jobTjParam = new JobTjParam();
//                    jobTjParam.setDeviceId(devicecode);
//                    jobTjParam.setDetectType(recordtype);
//                    String imageurl=objectList.get("url").toString();
//                    try {
//                        Map maprecogdata =new ObjectMapper().readValue(objectList.get("recogdata").toString(),Map.class);
//                        List<Map> points = new ArrayList<>();
//                        //
//                        List<Map> objectresult = (List<Map>) maprecogdata.get("ObjectList");
//                        if(objectresult.size()<1){
//                            logger.info("  objectresult is empty");
//                            continue;
//                        }
//                        //õλ
//                        TraffpictureParam traffpictureParamresult = eventWriteService.getResult(Integer.parseInt(taskinfo.getMetatype())
//                                , roiarray,imageurl , objectresult, jobTjParam, points);
//
//                        eventWriteService.setTraffpictureParam(recordtype,devicecode,
//                                objectList.get("timestamp").toString(),
//                                traffpictureParamresult);
//                        //ͼƬ߲ϴ
//                        String basepath = DateUtils.formatCurrDayYM()+
//                                File.separator+DateUtils.formatCurrDayDD()+ File.separator+
//                                devicecode ;
//                        String filename = devicecode+"_"+ DateUtils.formatCurrDateNoSign()+ "_result.jpg";
//                        eventWriteService.uploadPicture(traffpictureParamresult,imageurl, points, basepath, filename);
//                        String filenameurl=File.separator+outpath+File.separator+basepath+File.separator+filename;
//                        jobTjParam.setImageUrl(weburl+filenameurl);
////                            logger.info("file path:{}",filenameurl);
//                        traffpictureParamresult.setImagedata(filenameurl);
//                        traffpictureParamresult.setProcessstatus("-1");
//                        traffPictureService.updateTraffpicture(traffpictureParamresult);
//
//                        //ص
////                            logger.info("send to dianxin data:{}",JSONObject.toJSONString(jobTjParam));
//                        eventWriteService.sendEventByCallUrl(traffpictureParamresult, jobTjParam, taskinfo.getUrl().equals("")?callbackurl:taskinfo.getUrl());
//
//                        if (unionId.contains(devicecode)) {
//                            VoiceData voicedata = new VoiceData();
//                            voicedata.setAppKey(appKey);
//                            voicedata.setCorpId(corpId);
//                            Voice voice = new Voice();
//                            voice.setEventId(eventId);
//                            voice.setUnionId(unionId);
//                            voicedata.setRequestData(voice);
//                            // logger.info(" send to  voice: {}", new ObjectMapper().writeValueAsString(voicedata));
//                            eventWriteService.sendVoice(voicedata);
//                        }
//                        //͸澯ǰ
//                        webSocket.GroupSending(new ObjectMapper().writeValueAsString(traffpictureParamresult));
//                    } catch (Exception ex) {
//
//                    }
//                    //
//                    //getMetaData( objectresult );
//                }
//
//            }
//            //}
//            return ResultUtil.success();
//        } else {
//            logger.info("زڸ÷Χ");
//        }
//        //record Progress ֶΣ0Ϊ δ⣬-2 Ϊʧܣ
//        //жװ
//        return ResultUtil.success();
//    }
//    private void getMetaData( List<Map> objectresult ) {
//        if (null != metadata) {
//            traffpictureParamresult.setMetatype(String.valueOf(metadata.get("Type")));
//            if ("1".equals(metadata.get("Type"))) {
//                //涨Χڼ⵽
//                Pedestrian meta = new  ObjectMapper().convertValue(metadata, Pedestrian.class);
//                meta.setId(traffpictureParamresult.getId());
//                pedestrianService.insertpedestrian(meta);
//                if (null != meta.getFaceBoundingBox()) {
//                    list.add(new ObjectBoundingBox(meta.getFaceBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getFaceBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getFaceBoundingBox().getW(),
//                            meta.getFaceBoundingBox().getH()
//                    ));
//                }
//                if (null != meta.getObjectBoundingBox()) {
//
//                    list.add(new ObjectBoundingBox(meta.getObjectBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getObjectBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getObjectBoundingBox().getW(),
//                            meta.getObjectBoundingBox().getH()
//                    ));
//                }
//
//                if (null != meta.getHeadBoundingBox()) {
//
//                    list.add(new ObjectBoundingBox(meta.getHeadBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getHeadBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getHeadBoundingBox().getW(),
//                            meta.getHeadBoundingBox().getH()
//                    ));
//                }
//
//                if (null != meta.getUpperBoundingBox()) {
//                    list.add(new ObjectBoundingBox(meta.getUpperBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getUpperBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getUpperBoundingBox().getW(),
//                            meta.getUpperBoundingBox().getH()
//                    ));
//                }
//                if (null != meta.getLowerBoundingBox()) {
//                    list.add(new ObjectBoundingBox(meta.getLowerBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getLowerBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getLowerBoundingBox().getW(),
//                            meta.getLowerBoundingBox().getH()
//                    ));
//                }
//
//            } else if (null != metadata && "2".equals(metadata.get("Type"))) {
//                //
//                Traffic meta = new  ObjectMapper().convertValue(metadata, Traffic.class);
//                meta.setId(traffpictureParamresult.getId());
//                //
//                trafficService.insertTraffic(meta);
//                if (null != meta.getObjectBoundingBox()) {
//
//                    list.add(new ObjectBoundingBox(meta.getObjectBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getObjectBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getObjectBoundingBox().getW(),
//                            meta.getObjectBoundingBox().getH()
//                    ));
//                }
//            } else if (null != metadata && "3".equals(metadata.get("Type"))) {
//                Face meta = new  ObjectMapper().convertValue(metadata, Face.class);
//                meta.setId(traffpictureParamresult.getId());
//                faceService.insertFace(meta);
//                if (null != meta.getFaceBoundingBox()) {
//                    traffpictureParam.setObjx(meta.getFaceBoundingBox().getX() + roiarray[0].intValue());
//                    traffpictureParam.setObjy(meta.getFaceBoundingBox().getY() + roiarray[1].intValue());
//                    traffpictureParam.setObjw(meta.getFaceBoundingBox().getW());
//                    traffpictureParam.setObjh(meta.getFaceBoundingBox().getH());
//                }
//
//                if (null != meta.getFaceBoundingBox()) {
//                    list.add(new ObjectBoundingBox(meta.getFaceBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getFaceBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getFaceBoundingBox().getW(),
//                            meta.getFaceBoundingBox().getH()
//                    ));
//                }
//                if (null != meta.getHeadBoundingBox()) {
//
//                    list.add(new ObjectBoundingBox(meta.getHeadBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getHeadBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getHeadBoundingBox().getW(),
//                            meta.getHeadBoundingBox().getH()
//                    ));
//                }
//                //ﳵ
//            } else if (null != metadata && "4".equals(metadata.get("Type"))) {
//                PeopleRideBicyc meta = new  ObjectMapper().convertValue(metadata, PeopleRideBicyc.class);
//                 meta.setId(traffpictureParamresult.getId());
//                peopleridebicycService.insertPeopleRideBicyc(meta);
//                if (null != meta.getFaceBoundingBox()) {
//                    list.add(new ObjectBoundingBox(meta.getFaceBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getFaceBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getFaceBoundingBox().getW(),
//                            meta.getFaceBoundingBox().getH()
//                    ));
//                }
//                if (null != meta.getObjectBoundingBox()) {
//
//                    list.add(new ObjectBoundingBox(meta.getObjectBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getObjectBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getObjectBoundingBox().getW(),
//                            meta.getObjectBoundingBox().getH()
//                    ));
//                }
//            }
//
//        }
//    }
    @RequestMapping(value = "/callback", method = RequestMethod.POST)
    @ResponseBody
    public ResultObj sendcallback(JobTjParam jobTjParam){
        logger.info(JsonUtil.objToStr(jobTjParam));
        return  ResultObj.ok();

    }

}
