package com.cx.cn.cxquartz.rabbitmq.comsumer;

import com.cx.cn.cxquartz.bean.QuartzTaskInformations;
import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.redis.OrderConsumer;
import com.cx.cn.cxquartz.service.quartz.SbtdspsrService;
import com.cx.cn.cxquartz.service.quartz.TraffAlarmRecordService;
import com.cx.cn.cxquartz.service.quartz.impl.ResultService;
import com.cx.cn.cxquartz.service.quartz.impl.VideoRTSPorURLService;
import com.cx.cn.cxquartz.util.DateUtils;
import com.cx.cn.cxquartz.util.JsonUtil;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.BatchingRabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * 消息处理并推送第三方
 */
@Component
public class SnapTaskConsumer implements BaseConsumer {
    private static final Logger logger = LoggerFactory.getLogger(SnapTaskConsumer.class);

    @Autowired
    ResultService resultService;

    @Value("${local.czurl}")
    private String czurl;
    @Value("${local.fxurl}")
    private String fxurl;

    @Value("${file.rootpath}")
    private String czrooturl;


    @Autowired
    private VideoRTSPorURLService videoRTSPorURLService;

    @Autowired
    private SbtdspsrService sbtdspsrService;
    @Autowired
    BatchingRabbitTemplate batchQueueRabbitTemplate;
    @Autowired
    private RestTemplate restTemplate;

    /**
     * 消息消费入口
     *
     * @param message
     * @param channel
     * @throws IOException
     */
    @Override
    public void consume(Message message, Channel channel) throws IOException {
        logger.info("SnapTaskConsumer 收到消息: {}", message.toString());
        QuartzTaskInformations msg = MessageHelper.msgToObj(message, QuartzTaskInformations.class);
        if (null != msg) {
            try {
                //调用抽帧服务
                String devicecode = msg.getExecuteparamter();
                String rtsporhls = "";
                logger.info("开始消费消息{}", msg.getId());
                //如果设备编号是用一次废一次的，此刻需要现场取得rtsp
                if (null != devicecode && devicecode.startsWith("33") && devicecode.length() != 18) {
                    //调用抽帧服务
                    String token = videoRTSPorURLService.getRTSPAccessToekenByDeviceCode(devicecode);
                    rtsporhls = videoRTSPorURLService.getRTSPByDeviceCode(token, devicecode);
                } else {
                    //取表里最新的rtsp 或者hls 的值
                    rtsporhls = sbtdspsrService.getRtspOrHLSByDeviceCode(devicecode);
                }

                if (rtsporhls.equals("")) {
                    //尝试重新抽帧一遍
                    String token = videoRTSPorURLService.getRTSPAccessToekenByDeviceCode(devicecode);
                    rtsporhls = videoRTSPorURLService.getRTSPByDeviceCode(token, devicecode);
                    if (rtsporhls.equals("")) {
                        logger.error(devicecode + "rtsp 、hls 地址为空");
                        return;
                    }
                }
                //将rtsp 作为参数调用抽帧服务


//                 String  result="{\n" +
//                         "    \"ret\": 0,\n" +
//                         "    \"desc\": \"succ!\",\n" +
//                         "    \"resourcePath\": \"http://zjh189.ncpoi.cc:7080/download/202109/08/33050300001327599605/33050300001327599605_20210908_134131031.jpg\",\n" +
//                         "    \"localuri\": \"/home/ubuntu/pictures/slice/202109/08/33050300001327599605/33050300001327599605_20210908_134131031.jpg\",\n" +
//                         "    \"timestamp\": \"2021-09-08 13:41:31.031\",\n" +
//                         "    \"devicecode\": \"33050300001327599605\"\n" +
//                         "}";
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                Map map = new HashMap();
                map.put("resourcePath", czrooturl + "/" + DateUtils.formatCurrDatefileYMD() + "/" + devicecode + "/" + devicecode + "_" + DateUtils.formatCurrDayNoSign() + "_" + DateUtils.formatCurrDateHHmmss() + ".jpg");
                map.put("deviceID", devicecode);
                map.put("resourceParam", rtsporhls);
                HttpEntity<Map> requestEntity = new HttpEntity<>(map, headers);
                logger.info("抽帧参数:{}", JsonUtil.objToStr(map));
                Map resultmap = restTemplate.postForObject(czurl, requestEntity, Map.class);
                if (null != resultmap.get("ret")) {
                    if (resultmap.get("ret").toString().equals("0")
                            && null != resultmap.get("resourcePath")
                            && !resultmap.get("resourcePath").toString().equals("")) {
                        //抽帧结果放到rabbttmq 中，根据msg 的检测metatype ,分别派发到不同的queue中，方便以后10条10条的去皮皮昂分析
                        Map m = new HashMap();
                        m.put("task", JsonUtil.objToStr(msg));
                        m.put("result", JsonUtil.objToStr(resultmap));
                        CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
                        batchQueueRabbitTemplate.send(QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getExchange(),
                                QueueConstants.QueueTaskEnum.QUEUE_TASK_ENUM.getRouteKey() + "_QST",
                                MessageHelper.objToMsg(m),
                                correlationData);
                    } else {
                        logger.error("抽帧失败:{}", JsonUtil.objToStr(resultmap));
                    }
                } else {
                    logger.error("返回状态码为null");
                }
            } catch (Exception ex) {
                logger.error("消费消息{}error:{}", msg.getId(), ex.toString());
            }
        }
    }
}
