package com.cx.cn.cxquartz.rabbitmq.comsumer;

import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.service.quartz.TraffAlarmRecordService;
import com.cx.cn.cxquartz.service.quartz.impl.EventWriteService;
import com.cx.cn.cxquartz.util.JsonUtil;
import com.cx.cn.cxquartz.vo.JobTjParam;
import com.cx.cn.cxquartz.vo.Voice;
import com.cx.cn.cxquartz.vo.VoiceData;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Map;

/**
 * 消息处理并推送第三方
 */
@Component
public class SendToVoiceConsumer implements BaseConsumer {
    private static final Logger logger = LoggerFactory.getLogger(SendToVoiceConsumer.class);
    @Autowired
    TraffAlarmRecordService traffAlarmRecordService;

    @Autowired
    EventWriteService eventWriteService;


    @Value("${voice.unionId}")
    private String unionId;

    @Value("${voice.appKey}")
    private String appKey;

    @Value("${voice.corpId}")
    private String corpId;

    @Value("${voice.eventId}")
    private Integer eventId;


    /**
     * 消息消费入口
     *
     * @param message
     * @param channel
     * @throws IOException
     */
    @Override
    public void consume(Message message, Channel channel) {
        logger.info("SendToVoiceConsumer 收到消息: {}", message.toString());
        Map result = MessageHelper.msgToObj(message, Map.class);
        if (null != result.get("id") && null!=result.get("traff") && null!=result.get("callback")) {
            JobTjParam jobTjParam=JsonUtil.strToObj(result.get("traff").toString(), JobTjParam.class);
            //回调声音触发事件
            if (null!=jobTjParam &&unionId.contains(jobTjParam.getDeviceId())) {
                VoiceData voicedata = new VoiceData();
                voicedata.setAppKey(appKey);
                voicedata.setCorpId(corpId);
                voicedata.setRequestData(new Voice(eventId,unionId));
                // logger.info(" send to  voice: {}", new ObjectMapper().writeValueAsString(voicedata));
               //同步推送
                eventWriteService.sendVoice(voicedata,result.get("callback").toString());
            }
            //推送告警到前端
           // webSocket.GroupSending(JsonUtil.objToStr(traffpictureParamresult));
        }



    }
}
