package com.cx.cn.cxquartz.config;


import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/***
 * ԶץĶ
 */
@Configuration
public class AutoSnapConfig {
    /**
     * 
     *
     * @return
     */
    @Bean
    public DirectExchange AutoSnapDirectExchange() {
        return new DirectExchange(QueueConstants.QueueAutoSnapEnum.QUEUE_AUTOSNAP_ENUM.getExchange());
    }

    /**
     *  trueʾǷ־
     *
     * @return
     */
    @Bean
    public Queue AutoSnapDirectQueue() {
        return new Queue(QueueConstants.QueueAutoSnapEnum.QUEUE_AUTOSNAP_ENUM.getQueue(), true);
    }

    /**
     * кͽ,ƥ·ɼ
     *
     * @return
     */
    @Bean
    public Binding BindingAutoSnapDirect() {
        return BindingBuilder.bind(AutoSnapDirectQueue()).to(AutoSnapDirectExchange()).with(QueueConstants.QueueAutoSnapEnum.QUEUE_AUTOSNAP_ENUM.getRouteKey());
    }
}