package com.cx.cn.cxquartz.controller;


import com.alibaba.fastjson.JSONObject;
import com.cx.cn.cxquartz.bean.QuartzTaskInformations;
import com.cx.cn.cxquartz.job.WebSocket;
import com.cx.cn.cxquartz.service.quartz.*;
import com.cx.cn.cxquartz.service.quartz.impl.EventWriteService;
import com.cx.cn.cxquartz.util.*;
import com.cx.cn.cxquartz.vo.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.*;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.io.*;
import java.util.*;
import java.util.List;

@RestController
@RequestMapping("/ext")
@PropertySource("classpath:file.properties")
public class ExtController {
    private static final Logger logger = LoggerFactory.getLogger(ExtController.class);
    @Autowired
    private QuartzService quartzService;
    @Value("${file.rtspurl}")
    private String rtspurl;
    @Value("${file.recogurl}")
    private String recogurl;
    @Value("${file.getrtspbyurl}")
    private String getrtspbyurl;
    @Value("${file.publicpictureurl}")
    private String publicpictureurl;

    @Value("${voice.appKey}")
    private String appKey;

    @Value("${voice.corpId}")
    private String corpId;

    @Value("${voice.eventId}")
    private Integer eventId;
    @Value("${file.rootpath}")
    private String filerootpath;

    @Value("${file.outpath}")
    private String outpath;


    @Value("${voice.unionId}")
    private String unionId;
    @Value("${countryside.callbackurl}")
    private String callbackurl;



    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private SbtdspsrService sbtdspsrService;
    @Autowired
    FtpService ftpService;
    @Autowired
    TraffAlarmRecordService traffAlarmRecordService;
    @Autowired
    TraffPictureService traffPictureService;
    @Autowired
    PedestrianService pedestrianService;
    @Autowired
    TrafficService trafficService;
    @Autowired
    FaceService faceService;
    @Value("${file.ftppath}")
    private String ftppath;
    @Autowired
    PeopleridebicycService peopleridebicycService;
    @Autowired
    WebSocket webSocket;
    @Autowired
    CodeService codeservice;
    @Autowired
    EventWriteService eventWriteService;
    RestUtil restutil = new RestUtil();

    @Resource
    public void setRestTemplate(RestTemplate restTemplate) {
        restutil.restTemplate = restTemplate;
    }

    @Resource
    public void setSbtdspsrService(SbtdspsrService sbtdspsrService) {
        restutil.sbtdspsrService = sbtdspsrService;
    }

    @RequestMapping(value = "/getRTSP/{photonum}", method = RequestMethod.POST)
    public String getrtsp(@RequestBody String videoid,
                          @PathVariable("photonum") Integer photonum) {
        //根据videoID查询  rtsp 值
        List<Sbtdspsr> sbtdspsrlist = sbtdspsrService.selectByRtsp(videoid);
        logger.info("sbtdspsrlist:{}", JSONObject.toJSON(sbtdspsrlist));
        if (sbtdspsrlist.size() == 0) {
            logger.info(videoid + "设备不存在");
            return ResultUtil.success();
        }
        Sbtdspsr sbtdspsr = sbtdspsrlist.get(0);
        //尝试抽取第一张图片
        List<String> imgUrls = new ArrayList<>();
        TraffAlarmRecord traffAlarmRecord = new TraffAlarmRecord();
        try {
            //尝试抽取图片
            logger.info("rtspurl" + rtspurl);
            String timestamp = restutil.getPicture(imgUrls, sbtdspsr.getSbbh(), rtspurl, traffAlarmRecord);
            logger.info("timestamp" + timestamp);
            if (timestamp.contains(".")) {
                traffAlarmRecord.setCreatetime(timestamp.split("\\.")[0]);
            } else {
                traffAlarmRecord.setCreatetime(timestamp);
            }
        } catch (Exception ex) {
            logger.info("getRTSP/1 error:{}", ex.toString());
            traffAlarmRecord.setCreatetime(DateUtils.formatCurrDate());
        }
        try {
            if (imgUrls.size() == 0) {
                restutil.getPicture(imgUrls, sbtdspsr.getSbbh(), rtspurl, traffAlarmRecord);
            }

            traffAlarmRecord.setFdid(sbtdspsr.getSbbh());
            traffAlarmRecord.setChannelid(Integer.parseInt(String.valueOf(sbtdspsr.getTdbh())));
            traffAlarmRecord.setAreaid(Long.parseLong(sbtdspsr.getXzbh()));
            traffAlarmRecord.setPushstatus(9);
            //免审
            traffAlarmRecord.setCheckstatus(9);
            //未提取特征
            traffAlarmRecord.setProcessstatus("-2");
            traffAlarmRecord.setImg1urlfrom(imgUrls.get(0));
            //String basepath = "gstraff/" + traffAlarmRecord.getFdid() + (traffAlarmRecord.getChannelid() < 10 ? "0" + traffAlarmRecord.getChannelid() : traffAlarmRecord.getChannelid()) + "/" + DateUtils.formatCurrDayNoSign();
            //Ftp ftp = ftpService.reloadFtp();
            //入表
            traffAlarmRecordService.inserTraffAlarmRecord(traffAlarmRecord);
            //FileTransferManager.transferFile(traffAlarmRecord, ftp, basepath);
            //更新图片地址
            // traffAlarmRecordService.updateTraffAlarmRecordUrl(traffAlarmRecord);
            return ResultUtil.success();
        } catch (Exception e) {
            logger.error("ext/getRTSPr-->error:{}" + e.toString());
        }
        return ResultUtil.success();
    }

    @RequestMapping(value = "/getDeviceSnapshotAndRecognize", method = RequestMethod.POST)
    public String getDeviceSnapshotAndRecognize(@RequestBody String devicecode) {
        //根据判断监控是否存在，该监控检测的事件是什么
        List<QuartzTaskInformations> mapList = sbtdspsrService.selectRecogByRtsp(devicecode);
        String model = "1";
        //图片框选出来的范围
        Long[] roiarray;
        if (null != mapList && !mapList.equals("") && mapList.size() > 0) {
            //查询该监控下面还没有经过分析的数据
            Map<String, Object> map = new HashMap<>();
            map.put("sbbh", devicecode);

            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            Map<String, Object> mapparam = new HashMap<>();
            roiarray = new Long[4];
            //获得该监控的检测业务与检测范围
            for (QuartzTaskInformations taskinfo : mapList) {
                roiarray[0] = new Long(taskinfo.getObjectx());
                roiarray[1] = new Long(taskinfo.getObjecty());
                roiarray[2] = new Long(taskinfo.getObjectw());
                roiarray[3] = new Long(taskinfo.getObjecth());

//                roiarray[0] = new Long(0);
//                roiarray[1] = new Long(0);
//                roiarray[2] = new Long(0);
//                roiarray[3] = new Long(0);
               // for (TraffAlarmRecord transferRecord : traffalarmrecordlist) {
                    mapparam.put("deviceCode", devicecode);
                    mapparam.put("model", model);
                    //mapparam.put("roi", roiarray);
//                    logger.info("recogurl="+recogurl);
                    Map objectList = restTemplate.getForObject(recogurl + "?deviceCode={deviceCode}&model={model}&roi=[]", Map.class, mapparam);

                    if (String.valueOf(objectList.get("ret")).equals("0")) {
                        //变成为已分析
                     //   transferRecord.setProcessstatus("-1");
                      //  traffAlarmRecordService.updateTraffAlarmRecordProcess(transferRecord);
                        String recordtype=taskinfo.getRecordtype();
                        JobTjParam jobTjParam = new JobTjParam();
                        jobTjParam.setDeviceId(devicecode);
                        jobTjParam.setDetectType(recordtype);
                        String imageurl=objectList.get("url").toString();
                        try {
                            Map maprecogdata =new ObjectMapper().readValue(objectList.get("recogdata").toString(),Map.class);
                            List<Map> points = new ArrayList<>();
                            //分析结果数据
                            List<Map> objectresult = (List<Map>) maprecogdata.get("ObjectList");
                            if(objectresult.size()<1){
                                logger.info("  objectresult is empty");
                                continue;
                            }
                            //获得点位
                            TraffpictureParam traffpictureParamresult = eventWriteService.getResult(Integer.parseInt(taskinfo.getMetatype())
                                    , roiarray,imageurl , objectresult, jobTjParam, points);

                            eventWriteService.setTraffpictureParam(recordtype,devicecode,
                                    objectList.get("timestamp").toString(),
                                    traffpictureParamresult);
                            //图片划线并上传
                            String basepath = DateUtils.formatCurrDayYM()+
                                    File.separator+DateUtils.formatCurrDayDD()+ File.separator+
                                    devicecode ;
                            String filename = devicecode+"_"+ DateUtils.formatCurrDateNoSign()+ "_result.jpg";
                            eventWriteService.uploadPicture(traffpictureParamresult,imageurl, points, basepath, filename);
                            String filenameurl=File.separator+outpath+File.separator+basepath+File.separator+filename;
                            jobTjParam.setImageUrl(filenameurl);
//                            logger.info("file path:{}",filenameurl);
                            traffpictureParamresult.setImagedata(filenameurl);
                            traffpictureParamresult.setProcessstatus("-1");
                            traffPictureService.updateTraffpicture(traffpictureParamresult);

                            //回调
//                            logger.info("send to dianxin data:{}",JSONObject.toJSONString(jobTjParam));
                            eventWriteService.sendEventByCallUrl(traffpictureParamresult, jobTjParam, taskinfo.getUrl().equals("")?callbackurl:taskinfo.getUrl());

                            if (unionId.contains(devicecode)) {
                                VoiceData voicedata = new VoiceData();
                                voicedata.setAppKey(appKey);
                                voicedata.setCorpId(corpId);
                                Voice voice = new Voice();
                                voice.setEventId(eventId);
                                voice.setUnionId(unionId);
                                voicedata.setRequestData(voice);
                               // logger.info(" send to  voice: {}", new ObjectMapper().writeValueAsString(voicedata));
                                eventWriteService.sendVoice(voicedata);
                            }
                            //推送告警到前端
                            webSocket.GroupSending(new ObjectMapper().writeValueAsString(traffpictureParamresult));
                        } catch (Exception ex) {

                        }
                        //其他数据如表
                        //getMetaData( objectresult );
                    }

                }
            //}
            return ResultUtil.success();
        } else {
            logger.info("监控不属于该范围");
        }
        //更新record 表Progress 字段，0为 未检测，-2 为检测失败，将检测
        //结果进行额外封装入表
        return ResultUtil.success();
    }

//    private void getMetaData( List<Map> objectresult ) {
//        if (null != metadata) {
//            traffpictureParamresult.setMetatype(String.valueOf(metadata.get("Type")));
//            if ("1".equals(metadata.get("Type"))) {
//                //规定范围内检测到人
//                Pedestrian meta = new  ObjectMapper().convertValue(metadata, Pedestrian.class);
//                meta.setId(traffpictureParamresult.getId());
//                pedestrianService.insertpedestrian(meta);
//                if (null != meta.getFaceBoundingBox()) {
//                    list.add(new ObjectBoundingBox(meta.getFaceBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getFaceBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getFaceBoundingBox().getW(),
//                            meta.getFaceBoundingBox().getH()
//                    ));
//                }
//                if (null != meta.getObjectBoundingBox()) {
//
//                    list.add(new ObjectBoundingBox(meta.getObjectBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getObjectBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getObjectBoundingBox().getW(),
//                            meta.getObjectBoundingBox().getH()
//                    ));
//                }
//
//                if (null != meta.getHeadBoundingBox()) {
//
//                    list.add(new ObjectBoundingBox(meta.getHeadBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getHeadBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getHeadBoundingBox().getW(),
//                            meta.getHeadBoundingBox().getH()
//                    ));
//                }
//
//                if (null != meta.getUpperBoundingBox()) {
//                    list.add(new ObjectBoundingBox(meta.getUpperBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getUpperBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getUpperBoundingBox().getW(),
//                            meta.getUpperBoundingBox().getH()
//                    ));
//                }
//                if (null != meta.getLowerBoundingBox()) {
//                    list.add(new ObjectBoundingBox(meta.getLowerBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getLowerBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getLowerBoundingBox().getW(),
//                            meta.getLowerBoundingBox().getH()
//                    ));
//                }
//
//            } else if (null != metadata && "2".equals(metadata.get("Type"))) {
//                //车辆
//                Traffic meta = new  ObjectMapper().convertValue(metadata, Traffic.class);
//                meta.setId(traffpictureParamresult.getId());
//                //新增到车辆详情表
//                trafficService.insertTraffic(meta);
//                if (null != meta.getObjectBoundingBox()) {
//
//                    list.add(new ObjectBoundingBox(meta.getObjectBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getObjectBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getObjectBoundingBox().getW(),
//                            meta.getObjectBoundingBox().getH()
//                    ));
//                }
//            } else if (null != metadata && "3".equals(metadata.get("Type"))) {
//                Face meta = new  ObjectMapper().convertValue(metadata, Face.class);
//                meta.setId(traffpictureParamresult.getId());
//                faceService.insertFace(meta);
//                if (null != meta.getFaceBoundingBox()) {
//                    traffpictureParam.setObjx(meta.getFaceBoundingBox().getX() + roiarray[0].intValue());
//                    traffpictureParam.setObjy(meta.getFaceBoundingBox().getY() + roiarray[1].intValue());
//                    traffpictureParam.setObjw(meta.getFaceBoundingBox().getW());
//                    traffpictureParam.setObjh(meta.getFaceBoundingBox().getH());
//                }
//
//                if (null != meta.getFaceBoundingBox()) {
//                    list.add(new ObjectBoundingBox(meta.getFaceBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getFaceBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getFaceBoundingBox().getW(),
//                            meta.getFaceBoundingBox().getH()
//                    ));
//                }
//                if (null != meta.getHeadBoundingBox()) {
//
//                    list.add(new ObjectBoundingBox(meta.getHeadBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getHeadBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getHeadBoundingBox().getW(),
//                            meta.getHeadBoundingBox().getH()
//                    ));
//                }
//                //人骑车
//            } else if (null != metadata && "4".equals(metadata.get("Type"))) {
//                PeopleRideBicyc meta = new  ObjectMapper().convertValue(metadata, PeopleRideBicyc.class);
//                 meta.setId(traffpictureParamresult.getId());
//                peopleridebicycService.insertPeopleRideBicyc(meta);
//                if (null != meta.getFaceBoundingBox()) {
//                    list.add(new ObjectBoundingBox(meta.getFaceBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getFaceBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getFaceBoundingBox().getW(),
//                            meta.getFaceBoundingBox().getH()
//                    ));
//                }
//                if (null != meta.getObjectBoundingBox()) {
//
//                    list.add(new ObjectBoundingBox(meta.getObjectBoundingBox().getX() + roiarray[0].intValue(),
//                            meta.getObjectBoundingBox().getY() + roiarray[1].intValue(),
//                            meta.getObjectBoundingBox().getW(),
//                            meta.getObjectBoundingBox().getH()
//                    ));
//                }
//            }
//
//        }
//    }


}
