
package com.cx.cn.cxquartz.vo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.util.List;

public class TaskResultObj {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    /**
     * 响应业务状态
     * 200	成功
     * 201	错误
     * 400	参数错误
     */
    private String errorCode;

    /**
     * 响应消息
     */
    private String errorMsg;

    /**
     * 响应中的数据
     */
    private Object data;

    public static TaskResultObj error(String status, String msg, Object data) {
        return new TaskResultObj(status, msg, data);
    }

    public static TaskResultObj ok(Object data) {
        return new TaskResultObj(data);
    }

    public static TaskResultObj ok() {
        return ok(null);
    }

    private TaskResultObj() {

    }

    public static TaskResultObj error(String status, String msg) {
        return new TaskResultObj(status, msg, null);
    }

    private TaskResultObj(String status, String msg, Object data) {
        this.errorCode = status;
        this.errorMsg = msg;
        this.data = data;
    }

    private TaskResultObj(Object data) {
        this.errorCode = "0";
        this.errorMsg = "success";
        this.data = data;
    }

    /**
     * 将json结果集转化为SysResult对象
     *
     * @param jsonData json数据
     * @param clazz SysResult中的object类型
     * @return SysResult对象
     */
    public static TaskResultObj formatToPojo(String jsonData, Class<?> clazz) {
        try {
            if (clazz == null) {
                return MAPPER.readValue(jsonData, TaskResultObj.class);
            }
            JsonNode jsonNode = MAPPER.readTree(jsonData);
            JsonNode data = jsonNode.get("data");
            Object obj = null;
            if (data.isObject()) {
                obj = MAPPER.readValue(data.traverse(), clazz);
            } else if (data.isTextual()) {
                obj = MAPPER.readValue(data.asText(), clazz);
            }
            return error(jsonNode.get("errorCode").toString(), jsonNode.get("errorMsg").asText(), obj);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 没有object对象的转化
     *
     * @param json 字符串
     * @return SysResult对象
     */
    public static TaskResultObj format(String json) {
        try {
            return MAPPER.readValue(json, TaskResultObj.class);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * Object是集合转化
     *
     * @param jsonData json数据
     * @param clazz 集合中的类型
     * @return SysResult对象
     */
    public static TaskResultObj formatToList(String jsonData, Class<?> clazz) {
        try {
            JsonNode jsonNode = MAPPER.readTree(jsonData);
            JsonNode data = jsonNode.get("data");
            Object obj = null;
            if (data.isArray() && data.size() > 0) {
                obj = MAPPER.readValue(data.traverse(),
                        MAPPER.getTypeFactory().constructCollectionType(List.class, clazz));
            }
            return error(jsonNode.get("errorCode").toString(), jsonNode.get("errorMsg").asText(), obj);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}