package com.cx.cn.cxquartz.job;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.websocket.*;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

@Component
@ServerEndpoint("/websocket/{name}")
public class WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(WebSocket.class);
    /**
     * 与某个客户端的连接对话，需要通过它来给客户端发送消息
     */
    private Session session;


    /**
     * 标识当前连接客户端的用户名
     */
    private String name;


    /**
     * 用于存所有的连接服务的客户端，这个对象存储是安全的
     */
    private static ConcurrentHashMap<String, WebSocket> webSocketSet = new ConcurrentHashMap<>();


    @OnOpen
    public void OnOpen(Session session, @PathParam(value = "name") String name) {
        this.session = session;
        this.name = name;
        // name是用来表示唯一客户端，如果需要指定发送，需要指定发送通过name来区分
        webSocketSet.put(name, this);
    }


    @OnClose
    public void OnClose() {
        webSocketSet.remove(this.name);
    }


    @OnError
    public void OnError(@PathParam("name") String name, Throwable throwable, Session session) {
        webSocketSet.remove(name);
    }


    @OnMessage
    public void OnMessage(String message) {
        //判断是否需要指定发送，具体规则自定义

        if(message.indexOf("HEARTBEAT")>=0){
            Map map=new HashMap();
            map.put("type","HEARTBEAT");
            map.put("ts",new Date().getTime());
            try {
                AppointSending(name, new ObjectMapper().writeValueAsString(map));
            }catch (Exception ex)
            {
                logger.error("websocket->OnMessage eror:{}",ex.toString());
            }
        }
    }

    /**
     * 群发
     *
     * @param message
     */
    public static void GroupSending(String message) {
        for (String name : webSocketSet.keySet()) {
            try {
                if (null != webSocketSet.get(name) && null != webSocketSet.get(name).session && null != webSocketSet.get(name).session.getBasicRemote())
                    webSocketSet.get(name).session.getBasicRemote().sendText(message);
            } catch (Exception e) {
                logger.error("websocket->GroupSending eror:{}",e.toString());
            }
        }
    }


    /**
     * 指定发送
     *
     * @param name
     * @param message
     */
    public void AppointSending(String name, String message) {
        if (null != webSocketSet.get(name) && null != webSocketSet.get(name).session && null != webSocketSet.get(name).session.getBasicRemote()) {
            synchronized (webSocketSet.get(name).session) {
                try {
                    webSocketSet.get(name).session.getBasicRemote().sendText(message);

                } catch (Exception e) {
                    logger.error("websocket->AppointSending eror:{}",e.toString());
                }
            }
        }
    }
}

