package com.cx.cn.cxquartz.service.quartz.impl;

import com.cx.cn.cxquartz.service.quartz.SbtdspsrService;
import com.cx.cn.cxquartz.util.DateUtils;
import com.cx.cn.cxquartz.vo.Sbtdspsr;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.web.client.RestTemplate;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


@Service
public class VideoRTSPorURLService {
    private static final Logger logger = LoggerFactory.getLogger(VideoRTSPorURLService.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private  SbtdspsrService sbtdspsrService;

    @Value("${hlsurl.token}")
    private String hlsurltoken;

    @Value("${hlsurl.url}")
    private String hlsurl;

    @Value("${rtspurl.token}")
    private String rtspurltoken;

    @Value("${rtspurl.url}")
    private String rtspurl;

    @Value("${rtspurl.appid}")
    private String appid;

    @Value("${rtspurl.appsecret}")
    private String appsecret;

    @Value("${rtspurl.params}")
    private String params;


    public  String getHLSToekenByDeviceCode(String deviceCode){
//        "resultCode": "0",
//                "httpStatus": 200,
//                "resultMsg": "成功",
//                "obj": "5f8d4fefb3670e1a7c64ed3bbf0202a006620f1d98ff8ea4ef504d1111188509",
//                "serverTime": "2021-07-21 10:37:26"
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        Map map=new HashMap();
        map.put("appId","WIMZjxpJ");
        map.put("sign", DigestUtils.md5DigestAsHex(("appId=WIMZjxpJappSecret=686303f6571a232946746856484ea42730fde5bdtimestamp="+ DateUtils.getTimeStamps()).getBytes()));
        HttpEntity<Map> requestEntity = new HttpEntity<>(map, headers);
       Map result= restTemplate.postForObject(hlsurltoken,requestEntity,Map.class);
        if(null!=result.get("resultCode") && "0".equals(result.get("resultCode").toString())
        && null!=result.get("httpStatus")  &&  Integer.parseInt(result.get("httpStatus").toString())==200)
        {
            //获得token 成功,更新表数据
           String token= String.valueOf(result.get("obj"));
           Long serverTime= Long.parseLong(result.get("serverTime").toString());
            String serverHlsTokenNextTime =DateUtils.addMin(new Date(serverTime),5);
            //根据设备编号更新token 及token 过期数据
            Sbtdspsr sbtdspsr=new  Sbtdspsr();
            sbtdspsr.setSbbh(deviceCode);
            sbtdspsr.setToken(token);
            sbtdspsr.setTokennexttime(serverHlsTokenNextTime);
            sbtdspsr.setResourcetype("2");
            sbtdspsrService.updateRTSPorHLSParam(sbtdspsr);
            return token;
            //根据token获得rtsp 地址
        }
        return null;
    }

    /***
     * 根据token 获得hls 地址
     * @param token
     * @return
     */
    public  String getHLSByDeviceCode(String token,String devicecode){
        //token 保活
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> httpEntity = new HttpEntity(headers);
        ResponseEntity<String> exchange = restTemplate.exchange(hlsurl+"?cameraIndexCode="+devicecode, HttpMethod.GET ,httpEntity,String.class);
        String body=exchange.getBody();
        try {
            Map result = new ObjectMapper().readValue(body, Map.class);
            if (null != result.get("resultCode") && "0".equals(result.get("resultCode").toString())
                    && null != result.get("httpStatus") && Integer.parseInt(result.get("httpStatus").toString()) == 200) {
                //获得token 成功,更新表数据
                String hls = String.valueOf(result.get("obj"));
//                "obj": "http://183.131.123.32:83/openUrl/fEBpgNq/live.m3u8",
//                        "httpStatus": 200,
//                        "resultCode": "0",
//                        "serverTime": "2021-07-21 12:40:06",
//                        "resultMsg": "成功"
                //根据设备编号更新hls和下次执行时间 数据，hls 有效期是5分钟
                Long expire= Long.parseLong(result.get("serverTime").toString());
                String serverHlsNextTime =DateUtils.addMin(new Date(expire),5);
                Sbtdspsr sbtdspsr=new  Sbtdspsr();
                sbtdspsr.setSbbh(devicecode);
                sbtdspsr.setUrlnexttime(serverHlsNextTime);
                sbtdspsr.setSqurllj(hls);
                sbtdspsrService.updateRTSPorHLSParam(sbtdspsr);

                return hls;
                //根据token获得rtsp 地址
            }
        }catch (Exception ex){

            logger.error("getHLSByDeviceCode"+ex.toString());
        }
        return null;
    }

    /***
     * 获得rtsp token书籍
     * @param deviceCode
     * @return
     */
    public  String getRTSPAccessToekenByDeviceCode(String deviceCode){
        //token 保活
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map result=restTemplate.getForObject(rtspurltoken+"?appid="+appid+"&appsecret="+appsecret,Map.class);
        if(null!=result.get("code") && "0".equals(result.get("code").toString())){
//            {
//                "code": "0",
//                    "msg": null,
//                    "obj": {
//                "expire": 1624435058554,
//                        "accessToken": "22712f9c6c8c889061513188878fb27a5ff5d1bd11bd4f80cc860170e24cf432a06118acf70d8e490fee04d73e676af76e8e2299b7a919d04a1d879e62069c9087e8c703ca0265c3"
//            }
            //获得token 成功,更新表数据
            Map obj=(Map) result.get("obj");
           String token=String.valueOf(obj.get("accessToken"));
            Long expire= Long.parseLong(obj.get("expire").toString());
            String serverRTSPTokenNextTime=DateUtils.formatDate(new Date(expire));
           //根据设备编号更新token 及token 过期数据
            Sbtdspsr sbtdspsr=new  Sbtdspsr();
            sbtdspsr.setSbbh(deviceCode);
            sbtdspsr.setTokennexttime(serverRTSPTokenNextTime);
            sbtdspsr.setToken(token);
            sbtdspsrService.updateRTSPorHLSParam(sbtdspsr);
            return token;
            //根据token获得rtsp 地址
        }
        return null;
    }

    public  String  getRTSPByDeviceCode(String token,String deviceCode) {
        String timestamp = String.valueOf(new Date().getTime());
        HttpHeaders headers = new HttpHeaders();
        String rtsp ="";
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("accessToken", token);
        headers.add("timestamp", timestamp);
        headers.add("sign", DigestUtils.md5DigestAsHex((params + deviceCode + "key" + timestamp).getBytes()));
        HttpEntity<String> httpEntity = new HttpEntity(headers);
        ResponseEntity<String> exchange = restTemplate.exchange(rtspurl + "?deviceCode=" + deviceCode, HttpMethod.GET, httpEntity, String.class);
        String body = exchange.getBody();
        logger.info("get  rtsp result:{}",body);
        Sbtdspsr sbtdspsr = new Sbtdspsr();
        try {
            Map result = new ObjectMapper().readValue(body, Map.class);
            if (null != result.get("errorCode") && "0".equals(result.get("errorCode").toString())) {
                sbtdspsr.setSbbh(deviceCode);
                //获得token 成功,更新表数据
                Map data = (Map) result.get("data");
//                {
//                    "data": {
//                    "hlsUri": "http://183.131.55.15:5079/hls/33010200001327361919.m3u8",
//                            "rtmpUri": "rtmp://183.131.55.25:30011/pssWork_2/l_194116",
//                            "rtspUri": "rtsp://183.131.55.25:30010/pssWork_2/l_194116"
//                },
//                    "errorCode": "0",
//                        "errorMsg": "success"
//                }
                rtsp = String.valueOf(data.get("rtspUri"));
                //省内设备 = 地址只能用一次 ,33开头的
                //        //集团设备 = 地址可以用20分钟，15位
                sbtdspsr.setSqurllj(rtsp);
            }
//                if (deviceCode.length() == 18) {
                    String serverHlsNextTime = DateUtils.addMin(new Date(), 20);
                    sbtdspsr.setUrlnexttime(serverHlsNextTime);
//                } else if (deviceCode.startsWith("330") && sbtdspsr.getSqurllj().indexOf("token=")>-1 &&deviceCode.length()!=18) {
//                    //无需更新，抽帧的时候再去调用,将设备的rtsp 地址换成null
//                    sbtdspsr.setUrlnexttime(null);
//                }
                //更新表里的数据
            if(null!=sbtdspsr.getSbbh() && !"".equals(sbtdspsr.getSbbh()))
                sbtdspsrService.updateRTSPorHLSParam(sbtdspsr);

                //根据token获得rtsp 地址
        } catch (Exception ex) {
            logger.error("getRTSPByDeviceCode" + ex.toString());
        }
        return rtsp;
    }
    /***
     * 根据rtsp 或者hls  去抽帧
     */



}

