package com.cx.cn.cxquartz.rabbitmq.comsumer.listener;

import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.rabbitmq.comsumer.BaseConsumer;
import com.cx.cn.cxquartz.rabbitmq.comsumer.BaseConsumerProxy;
import com.cx.cn.cxquartz.rabbitmq.comsumer.SnapShotConsumer;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * rtsp与hls超时过期更新
 */
@Component
public class RTSPorHLSReceiver {
    private static final Logger logger = LoggerFactory.getLogger(RTSPorHLSReceiver.class);
    @Autowired
    private SnapShotConsumer snapShotConsumer;

    @RabbitListener(queues = QueueConstants.QueueRTSPConsumer.QUEUE)
    public void process(Message message, Channel channel) {
        try {
//            logger.info("RTSPorHLSReceiver body:{}",message.getBody());
            BaseConsumerProxy baseConsumerProxy = new BaseConsumerProxy(snapShotConsumer);
            BaseConsumer proxy = (BaseConsumer) baseConsumerProxy.getProxy();
            if (null != proxy) {
                proxy.consume(message, channel);
            }
        } catch (Exception e) {
            logger.error("RTSPorHLSReceiver error:{}",e);
        }
    }
}
