package com.cx.cn.cxquartz.config;


import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/***
 * 自动抓拍队列
 */
@Configuration
public class SnapTaskConfig {
    /**
     * 创建交换机
     *
     * @return
     */
    @Bean
    public DirectExchange SnapTaskDirectExchange() {
        return new DirectExchange(QueueConstants.QueueSnapTaskEnum.QUEUE_SNAP_TASK_ENUM.getExchange());
    }

    /**
     * 创建队列 true表示是否持久
     *
     * @return
     */
    @Bean
    public Queue SnapTaskDirectQueue() {
        return new Queue(QueueConstants.QueueSnapTaskEnum.QUEUE_SNAP_TASK_ENUM.getQueue(), true);
    }

    /**
     * 将队列和交换机绑定,并设置用于匹配路由键
     *
     * @return
     */
    @Bean
    public Binding BindingSnapTaskDirect() {
        return BindingBuilder.bind(SnapTaskDirectQueue()).to(SnapTaskDirectExchange()).with(QueueConstants.QueueSnapTaskEnum.QUEUE_SNAP_TASK_ENUM.getRouteKey());
    }
}