package com.cx.cn.cxquartz.rabbitmq.comsumer.listener;

import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.rabbitmq.comsumer.BaseConsumer;
import com.cx.cn.cxquartz.rabbitmq.comsumer.BaseConsumerProxy;
import com.cx.cn.cxquartz.rabbitmq.comsumer.SnapTaskConsumer;
import com.cx.cn.cxquartz.service.quartz.TraffPictureService;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 告警信息结果分析
 */
@Component
public class SnapTaskReceiver {
    private static final Logger logger = LoggerFactory.getLogger(SnapTaskReceiver.class);
    @Autowired
    private SnapTaskConsumer snapTaskConsumer;

    @Autowired
    private TraffPictureService traffPictureService;

    @RabbitListener(queues = QueueConstants.QueueSnapTaskConsumer.QUEUE)
    public void process(Message message, Channel channel) {
        try {
//            logger.info("SnapTaskReceiver body:{}",message.getBody());
            BaseConsumerProxy baseConsumerProxy = new BaseConsumerProxy(snapTaskConsumer, traffPictureService);
            BaseConsumer proxy = (BaseConsumer) baseConsumerProxy.getProxy();
            if (null != proxy) {
                proxy.consume(message, channel);
            }
        } catch (Exception e) {
            logger.error("SnapTaskReceiver error:{}",e);
        }
    }
}
