package com.cx.cn.cxquartz.util;

import com.cx.cn.cxquartz.vo.TraffAlarmRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RestUtil {

    private static final Logger logger = LoggerFactory.getLogger(RestUtil.class);
    @Autowired
    public RestTemplate restTemplate;


    public  String  getPicture(List<String> imgUrls, String deviceCode, String rtspurl, TraffAlarmRecord record ) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        Map<String, Object> maps = new HashMap<>();
        maps.put("deviceCode", deviceCode);
        logger.info("rtspurl:{}",rtspurl);
        Map result = restTemplate.getForObject(rtspurl + "?deviceCode={deviceCode}", Map.class, maps);
        if(null!=result) {
            if (null != result.get("ret") && String.valueOf(result.get("ret")).equals("0")) {
                //获得图片地址
                imgUrls.add(result.get("url").toString());
                record.setImg1urlfrom(result.get("url").toString());
                record.setImg1path(result.get("localuri").toString());
                return  result.get("timestamp").toString();
            }

        }
        return null;
    }

        /// <summary>
        /// 读取远程文件的内容
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public static InputStream ReadFromURL(String serverFilePath)
        {
            try {
            HttpURLConnection connection = (HttpURLConnection) new URL(serverFilePath).openConnection();
            connection.setReadTimeout(2000);    //延迟连接
            connection.setConnectTimeout(8000);
            connection.setRequestMethod("GET");
            if (connection.getResponseCode() == HttpURLConnection.HTTP_OK || connection.getResponseCode() == HttpURLConnection.HTTP_NOT_MODIFIED) {
                InputStream inputStream = connection.getInputStream();
                return inputStream;
            }

            } catch (IOException e) {
                logger.error(e.toString());
            }
            return null;
        }



}
