package com.cx.cn.cxquartz.rabbitmq.comsumer;

import com.cx.cn.cxquartz.bean.GoalStructureParam;
import com.cx.cn.cxquartz.bean.TaskResult;
import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.service.quartz.AutoSnapService;
import com.cx.cn.cxquartz.service.quartz.impl.TaskRecog;
import com.cx.cn.cxquartz.util.JsonUtil;
import com.cx.cn.cxquartz.vo.Autosnaptaskinfo;
import com.cx.cn.cxquartz.vo.ImageList;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.io.File;
import java.io.IOException;
import java.util.*;

/**
 * 消息处理并推送第三方
 */
@Component
public class AutoSnapConsumer  implements BaseConsumer{

    private static final Logger logger = LoggerFactory.getLogger(AutoSnapConsumer.class);
    @Autowired
    AutoSnapService autoSnapService;

    @Autowired
    TaskRecog taskRecog;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${file.recogqsturl}")
    String  recogqsturl;

    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Value("${snapnote.note1}")
    String note1;

    /**
     * 消息消费入口
     *
     * @param message
     * @throws IOException
     */
    @Override
    public void consume(Message message,Channel channel) {
       //将取到的信息解析出来，根据xml中提取的设备编号和jpg地址去查询任务将图片存储到任务对应的服务器上，然后进行调用抽帧分析，产生告警
        //获取chanel 中数据，暂定数据类型为jpg地址与xml中提取的设备编号
        Map result = MessageHelper.msgToObj(message, Map.class);
        logger.info("note1 data:{}",JsonUtil.objToStr(result));
        if(null!=result.get("devicecode") && null!=result.get("timestamp") && null!=result.get("resourcePath")) {
            String devicecode = result.get("devicecode").toString();
            String timestamp = result.get("timestamp").toString();
            String resourcePath = note1+ File.separator + result.get("resourcePath").toString();
            //当前消费者是note1 节点的消费者，需要访问note1 路径下
            //根据设备id查询表中需要分析的任务(根据通道类型不同新建的不同任务，然后状态为开始自动抓拍的任务  ),获得设备编号，告警类别，检测对象，告警时间,图片相对地址，整合之后调用分析算法
            List<Autosnaptaskinfo> taskinfolist = autoSnapService.query(new Autosnaptaskinfo(devicecode));
            //根据算法来源决定放到哪个队列中进行消费
            for (Autosnaptaskinfo info : taskinfolist) {
                if (null!=info.getAlgorithmfrom() && info.getAlgorithmfrom().equals("1")) {
                    //调用视通算法服务
                    GoalStructureParam goalSparam = new GoalStructureParam();
                    ImageList img = new ImageList();
                    img.setImageID("1");
                    img.setFormat(2);
                    if (null != info.getRegionx() && !info.getRegionx().equals("")
                    &&null != info.getRegiony() && !info.getRegiony().equals("")
                            &&null != info.getRegionw() && !info.getRegionw().equals("")
                            &&null != info.getRegionh() && !info.getRegionh().equals("")
                    ) {
                            img.setRoi(new Long[]{Long.parseLong(info.getRegionx()),
                                    Long.parseLong(info.getRegiony()),
                                    Long.parseLong(info.getRegionw()),
                                    Long.parseLong(info.getRegionh())
                            });
                    }
                    img.setData(resourcePath);
                    List<ImageList> imgList = new ArrayList<>();
                    imgList.add(img);
                    goalSparam.setImageList(imgList);
                    goalSparam.setModel(info.getObjectType() == null ? 1 : Integer.parseInt(info.getObjectType()));
                    try {
                        String resultstr = restTemplate.postForObject(recogqsturl, goalSparam, String.class);
                        logger.info("resultstr===={}",resultstr);
                        Map resulMap = JsonUtil.strToObj(resultstr, Map.class);
                        if (null != resulMap.get("ret") && resulMap.get("ret").equals("200")) {
                            List<Map> resultList = (List<Map>) resulMap.get("ObjectList");
                            if (resultList.size() < 1) {
                                logger.info("  objectresult is empty");
                            }
                            TaskResult taskResult = new TaskResult(info.getDevicenum(),
                                    info.getRecordtype(), timestamp, img.getRoi() == null ? null : img.getRoi()[0], img.getRoi() == null ? null : img.getRoi()[1], img.getRoi() == null ? null : img.getRoi()[2], img.getRoi() == null ? null : img.getRoi()[3],
                                    resourcePath, info.getObjectType(), info.getSendtype(),info.getSendurl());
                            Map map = new HashMap();
                            map.put("ObjectList", resultList);
                            map.put("param", taskResult);
                            CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
                            rabbitTemplate.convertAndSend(QueueConstants.QueueEventProcessingEnum.QUEUE_EVENT_PROCESSING_ENUM.getExchange(),
                                    QueueConstants.QueueEventProcessingEnum.QUEUE_EVENT_PROCESSING_ENUM.getRouteKey(),
                                    MessageHelper.objToMsg(map),
                                    correlationData);
                        }
                }catch (Exception ex){
                        logger.error(devicecode+recogqsturl+" error ：{}",ex.toString());
                    }
                }

            }
        }


    }

}
