package com.cx.cn.cxquartz.rabbitmq.comsumer;

import com.cx.cn.cxquartz.helper.MessageHelper;
import com.cx.cn.cxquartz.service.quartz.impl.VideoRTSPorURLService;
import com.cx.cn.cxquartz.vo.Sbtdspsr;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SnapShotConsumer implements BaseConsumer{

    private static final Logger logger = LoggerFactory.getLogger(SnapShotConsumer.class);
    @Autowired
    VideoRTSPorURLService videoRTSPorURLService;
    @Override
    public void consume(Message message, Channel channel) {
        logger.info("SnapShotConsumer 收到消息: {}", message.toString());
        Sbtdspsr result = MessageHelper.msgToObj(message, Sbtdspsr.class);
        if (result.getTdlx()==1) {
            if(null!=result.getSbbh()&&(!result.getSbbh().startsWith("33") ||
                    (result.getSbbh().startsWith("33") &&result.getSbbh().length()==18))) {
                String token = videoRTSPorURLService.getRTSPAccessToekenByDeviceCode(result.getSbbh());
                videoRTSPorURLService.getRTSPByDeviceCode(token, result.getSbbh());
            }
        }
        else{
            //调用hls 的服务
            String token=videoRTSPorURLService.getHLSToekenByDeviceCode(result.getSbbh());
            videoRTSPorURLService.getHLSByDeviceCode(token,result.getSbbh());
        }
    }
}
