package com.cx.cn.cxquartz.controller;


import com.cx.cn.cxquartz.service.quartz.*;
import com.cx.cn.cxquartz.service.quartz.impl.VideoRTSPorURLService;
import com.cx.cn.cxquartz.util.DateUtils;
import com.cx.cn.cxquartz.util.JsonUtil;
import com.cx.cn.cxquartz.vo.JobTjParam;
import com.cx.cn.cxquartz.vo.ResultObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/ext")
public class ExtController {
    private static final Logger logger = LoggerFactory.getLogger(ExtController.class);

    @Autowired
    VideoRTSPorURLService videoRTSPorURLService;
    @Autowired
    SbtdspsrService sbtdspsrService;
    @Autowired
    RestTemplate restTemplate;

    @Value("${local.czurl}")
    private String czurl;

    @Value("${file.rootpath}")
    private String czrooturl;

    @RequestMapping(value = "/callback", method = RequestMethod.POST)
    @ResponseBody
    public ResultObj sendcallback(JobTjParam jobTjParam){
        logger.info(JsonUtil.objToStr(jobTjParam));
        return  ResultObj.ok();

    }

    @RequestMapping(value = "/getRTSP/{devicecode}", method = RequestMethod.GET)
    @ResponseBody
    public String  getsnapPicUrl(@PathVariable(value = "devicecode") String  devicecode) {
        String rtsporhls = "";
        //如果设备编号是用一次废一次的，此刻需要现场取得rtsp
        if (null != devicecode && devicecode.startsWith("33") && devicecode.length() != 18) {
            //调用抽帧服务
            String token = videoRTSPorURLService.getRTSPAccessToekenByDeviceCode(devicecode);
            rtsporhls = videoRTSPorURLService.getRTSPByDeviceCode(token, devicecode);
        } else {
            //取表里最新的rtsp 或者hls 的值
            rtsporhls = sbtdspsrService.getRtspOrHLSByDeviceCode(devicecode);
        }
        if (rtsporhls.equals("")) {
            //尝试重新抽帧一遍
            String token = videoRTSPorURLService.getRTSPAccessToekenByDeviceCode(devicecode);
            rtsporhls = videoRTSPorURLService.getRTSPByDeviceCode(token, devicecode);
            if (rtsporhls.equals("")) {
                logger.error(devicecode + "rtsp 、hls 地址为空");
                return "";
            }
        }
        //将rtsp 作为参数调用抽帧服务
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map map = new HashMap();
        map.put("resourcePath", czrooturl + "/" + DateUtils.formatCurrDatefileYMD() + "/" + devicecode + "/" + devicecode + "_" + DateUtils.formatCurrDayNoSign() + "_" + DateUtils.formatCurrDateHHmmss() + ".jpg");
        map.put("deviceID", devicecode);
        map.put("resourceParam", rtsporhls);
        HttpEntity<Map> requestEntity = new HttpEntity<>(map, headers);
        logger.info("VideoRTSPorURL param:{}", JsonUtil.objToStr(map));
        Map resultmap = restTemplate.postForObject(czurl, requestEntity, Map.class);
        if (null != resultmap.get("ret")) {
            if (resultmap.get("ret").toString().equals("0")
                    && null != resultmap.get("resourcePath")
                    && !resultmap.get("resourcePath").toString().equals("")) {
                //抽帧结果放到rabbttmq 中，根据msg 的检测metatype ,分别派发到不同的queue中，方便以后10条10条的去皮皮昂分析
                return resultmap.get("resourcePath").toString();
            } else {
                logger.error("VideoRTSPorURLService error:{}", JsonUtil.objToStr(resultmap));
            }
        } else {
            logger.error("VideoRTSPorURLService ->czurl> resultmap is null");
        }
        return "";
    }


    }
