package com.cx.cn.cxquartz.config;


import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/***
 * 推送声音告警给第三方
 */
@Configuration
public class SendToVoiceConfig {

    @Bean
    public DirectExchange sendToVoiceDirectExchange() {
        return new DirectExchange(QueueConstants.QueueSendToVoiceEnum.QUEUE_SEND_TO_VOICE_ENUM.getExchange());
    }

    @Bean
    public Queue sendToVoiceDirectQueue() {
        return new Queue(QueueConstants.QueueSendToVoiceEnum.QUEUE_SEND_TO_VOICE_ENUM.getQueue(), true);
    }

    @Bean
    public Binding BindingSendToVoiceDirect() {
        return BindingBuilder.bind(sendToVoiceDirectQueue()).to(sendToVoiceDirectExchange()).with(QueueConstants.QueueSendToVoiceEnum.QUEUE_SEND_TO_VOICE_ENUM.getRouteKey());
    }
}