package com.cx.cn.cxquartz.config;


import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/***
 *推送告警信息给第三方
 */
@Configuration
public class SendToDXConfig {

    @Bean
    public DirectExchange sendToDXDirectExchange() {
        return new DirectExchange(QueueConstants.QueueSendToDXEnum.QUEUE_SEND_TO_DX_ENUM.getExchange());
    }

    @Bean
    public Queue sendToDXDirectQueue() {
        return new Queue(QueueConstants.QueueSendToDXEnum.QUEUE_SEND_TO_DX_ENUM.getQueue(), true);
    }

    @Bean
    public Binding BindingSendToDXDirect() {
        return BindingBuilder.bind(sendToDXDirectQueue()).to(sendToDXDirectExchange()).with(QueueConstants.QueueSendToDXEnum.QUEUE_SEND_TO_DX_ENUM.getRouteKey());
    }
}