package com.cx.cn.cxquartz.rabbitmq.producer.callback;

import com.cx.cn.cxquartz.controller.ExtController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;

/**
 * 消息发送确认的回调
 */
@Component
public class ConsumerConfirmAndReturnCallback implements RabbitTemplate.ConfirmCallback, RabbitTemplate.ReturnCallback {

    private static final Logger logger = LoggerFactory.getLogger(ExtController.class);
    @Autowired
    private RabbitTemplate rabbitTemplate;

    /**
     * PostConstruct: 用于在依赖关系注入完成之后需要执行的方法上，以执行任何初始化.
     */
    @PostConstruct
    public void init() {
        //指定 ConfirmCallback
        rabbitTemplate.setConfirmCallback(this);
        //指定 ReturnCallback
        rabbitTemplate.setReturnCallback(this);
    }

    /**
     * 消息从交换机成功到达队列，spring.rabbitmq.publisher-returns=true
     */
    @Override
    public void returnedMessage(Message message, int replyCode, String replyText, String exchange, String routingKey) {
        logger.info(" info->" + new String(message.getBody(), StandardCharsets.UTF_8) + ",\n replyCode:" + replyCode
                + "\n replyText:" + replyText + "\n exchange:" + exchange + ",\\n routingKey:" + routingKey);
    }

    /**
     * 消息找不到对应的Exchange会先触发此方法
     * 如果消息没有到达交换机,则该方法中isSendSuccess = false,error为错误信息;
     * 如果消息正确到达交换机,则该方法中isSendSuccess = true;
     * 需要开启 confirm 确认机制
     * spring.rabbitmq.publisher-confirms=true
     */
    @Override
    public void confirm(CorrelationData correlationData, boolean isSendSuccess, String error) {
        if (correlationData != null) {
            if (!isSendSuccess) {
                logger.info("confirm callback->[{}]，error : [{}]", correlationData, error);
            }
        }
    }
}
