package com.cx.cn.cxquartz.rabbitmq.comsumer.listener;

import com.cx.cn.cxquartz.rabbitmq.QueueConstants;
import com.cx.cn.cxquartz.rabbitmq.comsumer.BaseConsumer;
import com.cx.cn.cxquartz.rabbitmq.comsumer.BaseConsumerProxy;
import com.cx.cn.cxquartz.rabbitmq.comsumer.SendToDXConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.rabbitmq.client.Channel;

import java.io.IOException;
import org.springframework.amqp.core.Message;
/**
 * 推送告警给第三方
 */
@Component
public class SendtoDXReceiver {
    private static final Logger logger = LoggerFactory.getLogger(SendtoDXReceiver.class);
    @Autowired
    private SendToDXConsumer sendToDXConsumer;

    /**
     * 消息接收处理
     *
     * @param message
     * @param channel
     * @throws IOException
     */
    @RabbitListener(queues = QueueConstants.QueueSendToDXConsumer.QUEUE,containerFactory="rabbitListenerContainerFactory")
    public void consume(Message message, Channel channel) {
        try {
//            logger.info("SendtoDXReceiver body:{}", message.getBody());
            BaseConsumerProxy baseConsumerProxy = new BaseConsumerProxy(sendToDXConsumer);
            BaseConsumer proxy = (BaseConsumer) baseConsumerProxy.getProxy();
            if (null != proxy) {
                proxy.consume(message, channel);
            }
        }catch (Exception ex){
            logger.error("SendtoDXReceiver error:{}", ex.toString());
        }
    }
}
