package com.cx.cn.cxquartz.config;

import com.cx.cn.cxquartz.service.quartz.RabbitMqService;
import com.cx.cn.cxquartz.service.quartz.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;



@Configuration
@EnableScheduling
public class ScheduleTaskConfig {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleTaskConfig.class);
    @Autowired
    private RabbitMqService rRabbitMqService;

    @Autowired
    private JavaMailSenderImpl mailSender;

    @Value("${sendmail.to}")
    String sendmailto;

    @Value("${spring.mail.username}")
    String username;
    @Value("${rabbit.queues}")
    String queues;

    @Autowired
    TaskService taskService;

    @Scheduled(cron = "0 */15 * * * ?")//每隔5分钟统计1个小时前到目前为止的数据
    private void statistoday() {
        try {
            //查询警戒值
            int alarmValue = 100;
            StringBuffer buffer = new StringBuffer();
            String alarmvalue = taskService.getRabbitmqValue();
            if (null != alarmvalue) {
                alarmValue = Integer.parseInt(alarmvalue);
            }
            String[] strarray = queues.split(",");
            for (String item : strarray) {
                try {
                    int count = rRabbitMqService.getMessageCount("RabbitMQ.DirectQueue." + item);
                    //遍历所有队列名字
                    if (count > alarmValue) {
                        //发送邮件通知
                        buffer.append(item);
                        buffer.append(" 告警数量：");
                        buffer.append(count);
                        buffer.append("/n");
                    }
                    logger.info("队列{} 当前 count:{}", item, count);
                }catch (Exception ex){
                    logger.error("队列{}",item);

                }
            }
            if (buffer.length() > 0) {
                SimpleMailMessage simpleMailMessage = new SimpleMailMessage();
                simpleMailMessage.setFrom(username);
                simpleMailMessage.setTo(sendmailto);
                simpleMailMessage.setSubject("队列数量异常告警,请及时处理！");
                simpleMailMessage.setText(buffer.toString());
                mailSender.send(simpleMailMessage);

            }
        }
        catch (Exception ex){

            logger.error(ex.toString());
        }
    }

}
