package im.dx.system.controller;

import com.github.pagehelper.PageInfo;
import im.dx.common.annotation.RefreshFilterChain;
import im.dx.common.util.PageResultBean;
import im.dx.common.util.ResultBean;
import im.dx.system.model.Menu;
import im.dx.system.service.MenuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Controller
@RequestMapping("/menu")
public class MenuController {

    @Autowired
    private MenuService menuService;

    @GetMapping("/index")
    public String index() {
        return "menu/menu-list";
    }
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /***
     * 获取菜单列表
     * @param parentId
     * @return
     */
    @GetMapping("/list")
    @ResponseBody
    public PageResultBean<Menu> getList(@RequestParam(required = false) Integer parentId,
                              @RequestParam(value = "page", defaultValue = "1") int page,
                              @RequestParam(value = "limit", defaultValue = "10")int limit) {
        List<Menu> menuList = menuService.selectByParentId(page,limit,parentId);
        PageInfo<Menu> userPageInfo = new PageInfo<>(menuList);
        return new PageResultBean<>(userPageInfo.getTotal(), userPageInfo.getList());
    }

    @GetMapping
    public String add(Model model) {
        return "menu/menu-add";
    }

    @GetMapping("/tree")
    @ResponseBody
    public ResultBean tree() {
        return ResultBean.success(menuService.getALLTree());
    }

    @GetMapping("/tree/root")
    @ResponseBody
    public ResultBean treeAndRoot() {
        return ResultBean.success(menuService.getALLMenuTreeAndRoot());
    }

    @GetMapping("/tree/root/operator")
    @ResponseBody
    public ResultBean menuAndCountOperatorTreeAndRoot() {
        return ResultBean.success(menuService.getALLMenuAndCountOperatorTreeAndRoot());
    }

    /**
     * 新增菜单
     * @param menu
     * @return
     */
    @RefreshFilterChain
    @PostMapping
    @ResponseBody
    public ResultBean add(Menu menu) {
        menu.setCreateTime(sdf.format(new Date()));
        menu.setModifyTime(menu.getCreateTime());
        menuService.insert(menu);
        return ResultBean.success();
    }

    /***
     * 删除菜单
     * @param menuId
     * @return
     */
    @RefreshFilterChain
    @DeleteMapping("/{menuId}")
    @ResponseBody
    public ResultBean delete(@PathVariable("menuId") Integer menuId) {
        menuService.deleteByIDAndChildren(menuId);
        return ResultBean.success();
    }

    @GetMapping("/{menuId}")
    public String updateMenu(@PathVariable("menuId") Integer menuId, Model model) {
        Menu menu = menuService.selectByPrimaryKey(menuId);
        model.addAttribute("menu", menu);
        return "menu/menu-add";
    }

    /***
     * 修改菜单
     * @param menu
     * @return
     */

    @RefreshFilterChain
    @PutMapping
    @ResponseBody
    public ResultBean update(Menu menu) {
        menu.setModifyTime(sdf.format(new Date()));
        menuService.updateByPrimaryKey(menu);
        return ResultBean.success();
    }
//
//    /***
//     * 调整部门排序
//     * @param currentId
//     * @param swapId
//     * @return
//     */
//    @PostMapping("/swap")
//    @ResponseBody
//    public ResultBean swapSort(Integer currentId, Integer swapId) {
//        menuService.swapSort(currentId, swapId);
//        return ResultBean.success();
//    }




}