let myecharts_jrll, myecharts_sjtj, myecharts_ydzs, myecharts_ycsdfb, myecharts_cllxzb;

//今日流量
let option_jrll = {
    tooltip: {
        trigger: 'axis',
    },
    grid: {
        left: '8%',
        top: '8%',
        right: '4%',
        bottom: '12%',
    },
    xAxis: {
        type: 'category',
        data: ['0-2(h)', '2-4(h)', '4-6(h)', '6-8(h)',
            '8-10(h)', '10-12(h)', '12-14(h)', '14-16(h)', '16-18(h)', '18-20(h)', '20-22(h)', '22-24(h)',],
        axisLine: {  //这是x轴文字颜色
            lineStyle: {
                color: "#a9a9a9",
            }
        }
    },
    yAxis: {
        type: 'value',
        axisLine: {//这是y轴文字颜色
            lineStyle: {
                color: "#a9a9a9",
            }
        },
        splitLine: {
            show: true,
            lineStyle: {
                color: ['#b9b9b9'],
                width: 1,
                type: 'solid'
            }
        }
    },
    series: [{
        data: '',
        type: 'bar',
        showBackground: true,
        backgroundStyle: {
            color: '#CCE8E9'
        },
        barWidth: 20,
        itemStyle: {
            normal: {
                color: new echarts.graphic.LinearGradient(0, 1, 0, 0, [{
                    offset: 0,
                    color: "#8CB4DB" // 0% 处的颜色
                }, {
                    offset: 1,
                    color: "#71D1C0" // 100% 处的颜色
                }], false),
                //柱形图圆角，初始化效果
                barBorderRadius: [15, 15, 0, 0],

            }
        },
    }]
};
//事件统计
let option_sjtj = {
    tooltip: {
        trigger: 'axis',
        formatter: function (params, ticket, callback) {
            var showHtm = params[0].axisValue + '<br>';
            value_zr = params[0].value;
            value_jr = params[1].value;
            let values;
            if (value_zr == 0 || value_jr == 0) {
                // values = Math.abs(Math.round((value_jr - value_zr) / 1 * 10000) / 100.00);
                values = 100;
            } else {
                values = Math.abs(Math.round((value_jr - value_zr) / value_zr * 10000) / 100.00);
            }
            if ((value_jr - value_zr) > 0) {
                showHtm += '上升：' + values + '%' + '<br>';
            } else if ((value_jr - value_zr) == 0) {
                showHtm += '持平' + '<br>';
            } else {
                showHtm += '下降：' + values + '%' + '<br>';
            }
            for (var i = 0; i < params.length; i++) {
                //名称
                var text = params[i].seriesName;
                //值
                var value = params[i].value;
                showHtm += text + '--' + ' 数量：' + value + '<br>'
            }
            return showHtm;
        }
    },
    grid: {
        left: '8%',
        top: '15%',
        right: '4%',
        bottom: '12%',
    },
    legend: {
        data: ['昨日', '今日'],
        right: '40',
        top: '10'
    },
    xAxis: [
        {
            type: 'category',
            data: [],
            axisPointer: {
                type: 'shadow'
            },
            axisLine: {  //这是x轴文字颜色
                lineStyle: {
                    color: "#a9a9a9",
                }
            }
        }
    ],
    yAxis: [
        {
            type: 'value',
            axisLabel: {
                formatter: '{value}'
            },
            axisLine: {//这是y轴文字颜色
                lineStyle: {
                    color: "#a9a9a9",
                }
            },
            splitLine: {
                show: true,
                lineStyle: {
                    color: ['#b9b9b9'],
                    width: 1,
                    type: 'solid'
                }
            }
        },
    ],
    series: [
        {
            name: '昨日',
            type: 'bar',
            data: [],
            barWidth: 30,
            itemStyle: {
                normal: {
                    color: new echarts.graphic.LinearGradient(0, 1, 0, 0, [{
                        offset: 0,
                        color: "#AADBF4" // 0% 处的颜色
                    }, {
                        offset: 1,
                        color: "#5C85F5" // 100% 处的颜色
                    }], false),
                    //柱形图圆角，初始化效果
                    barBorderRadius: [8, 8, 0, 0],

                }
            },
        },
        {
            name: '今日',
            type: 'bar',
            data: [],
            barWidth: 30,
            itemStyle: {
                normal: {
                    color: new echarts.graphic.LinearGradient(0, 1, 0, 0, [{
                        offset: 0,
                        color: "#50DBC4" // 0% 处的颜色
                    }, {
                        offset: 1,
                        color: "#03C3CF" // 100% 处的颜色
                    }], false),
                    //柱形图圆角，初始化效果
                    barBorderRadius: [8, 8, 0, 0],

                }
            },
        },
    ]
};
//拥堵指数
let option_ydzs = {
    tooltip: {
        formatter: '{b}：{c}'
    },
    series: [
        {
            name: '',
            type: 'gauge',
            min: 0,
            max: 10,
            splitNumber: 10,
            radius: '90%',
            axisLine: {            // 坐标轴线
                lineStyle: {       // 属性lineStyle控制线条样式
                    color: [
                        [1, new echarts.graphic.LinearGradient(0, 0, 1, 0, [
                            {
                                offset: 0,
                                color: "rgb(255, 161, 55)"
                            },
                            {
                                offset: 1,
                                color: "#FD481B"
                            }
                        ])
                        ]],
                    width: 8,
                    shadowColor: '#fff', //默认透明
                }
            },
            axisLabel: {            // 坐标轴小标记
                fontWeight: 'bolder',
                color: '#FD481B',
                shadowColor: 'fff', //默认透明
                shadowBlur: 10
            },
            axisTick: {            // 坐标轴小标记
                length: 10,        // 属性length控制线长
                lineStyle: {       // 属性lineStyle控制线条样式
                    color: 'auto',
                    shadowColor: '#fff', //默认透明
                }
            },
            splitLine: {           // 分隔线
                length: 20,         // 属性length控制线长
                lineStyle: {       // 属性lineStyle（详见lineStyle）控制线条样式
                    width: 2,
                    color: '#FD941D',
                    shadowColor: '#fff', //默认透明
                }
            },
            title: {
                textStyle: {       // 其余属性默认使用全局文本样式，详见TEXTSTYLE
                    fontSize: 14,
                    color: '',
                    shadowColor: '#fff', //默认透明
                    shadowBlur: 10
                }
            },
            detail: {
                shadowColor: '#fff', //默认透明
                shadowBlur: 5,
                offsetCenter: [0, '50%'],       // x, y，单位px
                textStyle: {       // 其余属性默认使用全局文本样式，详见TEXTSTYLE
                    fontWeight: 'bolder',
                    color: '#6791f5'
                }
            },
            data: [{value: 7.5, name: '实时拥堵指数'}],
            roundCap: true
        }
    ]
};
//异常时段分布
let option_ycsdfb = {
    tooltip: {
        trigger: 'axis',
        textStyle: {
            fontSize: 14
        },
    },
    legend: {
        right: '10%',
        data: ['异常事件数值'],
        textStyle: {
            color: '#a9a9a9',
        },
        right: '40',
        top: '10'
    },
    grid: {
        left: '4%',
        top: '15%',
        right: '4%',
        bottom: '12%',
    },
    xAxis: [
        {
            type: 'category',
            data: ['0-2(h)', '2-4(h)', '4-6(h)', '6-8(h)',
                '8-10(h)', '10-12(h)', '12-14(h)', '14-16(h)', '16-18(h)', '18-20(h)', '20-22(h)', '22-24(h)',],
            axisLabel: {
                show: true,
                textStyle: {
                    color: '#a9a9a9',
                    fontSize: 12
                }
            },
        }
    ],
    yAxis: [
        {
            type: 'value',
            axisLabel: {
                show: true,
                textStyle: {
                    color: '#a9a9a9',
                    fontSize: 12
                }
            },
            splitLine: {
                show: true,
                lineStyle: {
                    color: '#a9a9a9',
                    width: 1,
                    type: 'solid'
                }
            }
        }
    ],
    series: [
        {
            name: '异常事件数值',
            type: 'line',
            areaStyle: {},
            data: [],
            smooth: true,
            textStyle: {
                fontSize: 12
            },
            itemStyle: {
                normal: {   //颜色渐变函数 前四个参数分别表示四个位置依次为左、下、右、上
                    color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                            offset: 0, color: '#F6C671' // 0% 处的颜色
                        }, {
                            offset: 1, color: 'rgba(206, 232, 231, 0.5)' // 100% 处的颜色
                        }]
                    ),  //背景渐变色
                    lineStyle: {        // 系列级个性化折线样式
                        width: 3,
                        type: 'solid',
                        color: "#F0B446"
                    }
                },
            },
        },
    ]
};
//车辆类型占比
let option_cllxzb = {
    tooltip: {
        trigger: 'item',
        formatter: '{a} <br/>{b}: {c} ({d}%)'
    },
    legend: {
        orient: 'vertical',
        left: 10,
        data: [],
        //设置分页
        type: 'scroll',
        pageTextStyle: {
            color: '#444444',
        },
        pageIconColor: '#444444',
        pageIconInactiveColor: 'white',
    },
    series: [
        {
            name: '车辆类型',
            type: 'pie',
            radius: ['50%', '80%'],
            center: ['70%', '50%'],
            //设置饼图最小角度
            minAngle: 30,
            avoidLabelOverlap: false,
            label: {
                show: false,
                position: 'center'
            },
            emphasis: {
                label: {
                    show: true,
                    fontSize: '15',
                    fontWeight: 'bold'
                }
            },
            labelLine: {
                show: false
            },
            data: []
        }
    ],
    color: ['#2EC7C9', '#B6A2DE', '#5AB1EF', '#FFB980', '#D87A80', '#97B552', '#E5CF0D', '#8D98B3']
};

let vue_sy = new Vue({
    el: '#sy',
    data: {
        data_gfdw: [],
        dw_name: '',
        dw_id: '',
        time: getTime().jssj,
        times: '2020-10-21 23:59:59',
        deptid:getCookie("bjpt_deptId")+'',
        data_sjlx:[],
        count:'0',
        data_sjlx1:[],
    },
    methods: {
        qhdw: function () {
            vue_jk.query();
            vue_jk.monitor_data = {};
            $("#myModal").modal("show");
        },
    },
    mounted(){
        // this.query_monirot();
        //今日流量
        myecharts_jrll = echarts.init(document.getElementById("jrll"));
        myecharts_jrll.setOption(option_jrll);
        //事件统计
        myecharts_sjtj = echarts.init(document.getElementById("sjtj"));
        myecharts_sjtj.setOption(option_sjtj);
        //拥堵指数
        // myecharts_ydzs = echarts.init(document.getElementById("ydzs"));
        // myecharts_ydzs.setOption(option_ydzs);
        //异常时段分布
        myecharts_ycsdfb = echarts.init(document.getElementById("ycsdfb"));
        myecharts_ycsdfb.setOption(option_ycsdfb);
        //车辆类型占比
        myecharts_cllxzb = echarts.init(document.getElementById("cllxzb"));
        myecharts_cllxzb.setOption(option_cllxzb);
        window.addEventListener("resize", function () {
            myecharts_jrll.resize();
            myecharts_sjtj.resize();
            // myecharts_ydzs.resize();
            myecharts_ycsdfb.resize();
            myecharts_cllxzb.resize();
        });
        // this.jrll();
        // this.gfphb();
    }
});
let vue_jk = new Vue({
    el: '#myModal',
    data: {
        monitor_data: {},
        searchText: '',
    },
    methods: {
        fastSearch: function () {
            $("#tree-xzxq").treeview('search', [this.searchText, {
                ignoreCase: true,      // case insensitive
                exactMatch: false,     // like or equals
                revealResults: true,   // reveal matching nodes
            }]);
        },
        define: function () {
            if (this.monitor_data.href == undefined) {
                info_new("未选择监控");
                window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
                $("#myModal").css('overflow', 'auto');
            } else {
                vue_sy.dw_name = this.monitor_data.text;
                // alert(this.monitor_data.href);
                vue_sy.dw_id = this.monitor_data.href;
                vue_sy.jrll();
                $("#myModal").modal("hide");
            }
        },
        query: function () {
            $.ajax({
                url: "/dept/listvideo",
                dataType: "json",
                type: "GET",
                data: {
                    deptId: getCookie("bjpt_deptId"),
                    username: getCookie("bjpt_realName"),
                    tdmc:'',
                },
                success: function (result) {
                    let defaultData = [];
                    if (result.code == 0) {
                        defaultData = toTree(result.data,  '0');
                        $('#tree-xzxq').treeview({
                            expandIcon: 'glyphicon glyphicon-triangle-right selected-span',
                            collapseIcon: 'glyphicon glyphicon-triangle-bottom selected-span',
                            nodeIcon: 'glyphicon glyphicon-folder-open selected-span',
                            selectedBackColor: '#ff000000',
                            selectedColor: '#368ff3',
                            onhoverColor: '#73a5ff26',
                            showBorder: false,
                            data: defaultData
                        });
                        $('#tree-xzxq').on('nodeSelected', function (event, data) {
                            vue_jk.monitor_data = data;
                            // alert('点击选中');
                        });
                        $('#tree-xzxq').on('nodeUnselected', function (event, data) {

                            // alert('取消选择');
                        });
                    }
                }
            });
            // $.ajax({
            //     url: "/dept/getDeptParent/" + getCookie("bjpt_deptId"),
            //     dataType: "json",
            //     type: "GET",
            //     data: {},
            //     success: function (result) {
            //         if (result.code == 0) {
            //             let parIds = result.data.parentId;
            //
            //         }
            //     }
            // });
        }
    },
});

function toTree(list, parId) {
    let len = list.length;

    function loop(parId) {
        let res = [];
        for (let i = 0; i < len; i++) {
            let item = list[i];
            if (item.parentId === parId) {
                item.nodes = loop(item.href);
                let arr = {
                    href: item.href,
                    text: item.text,
                    level: item.level,
                    parentId: item.parentId,
                }
                if (item.level == 0 || item.level == 1 || item.level == 2) {
                    arr.selectable = false;
                    arr.state = {expanded: true};
                } else {
                    arr.icon = 'glyphicon glyphicon-facetime-video zx',
                        arr.state = {expanded: false};
                    arr.selectable = true;
                }
                if (item.nodes.length > 0) {
                    arr.nodes = item.nodes;
                }
                res.push(arr);
            }
        }
        return res
    }

    return loop(parId)
}
