package im.dx.system.model;


import lombok.Getter;

/**
 * 通用返回值 枚举类
 * @author cp
 */
@Getter
public enum ResponseEnum {

    /* 错误信息 */
    E_1000(1000, "返回值必须为PageResult"),
    E_1001(1001, "必须传递分页参数"),
    E_1002(1002, "参数值异常"),
    E_1003(1003, "参数值转换异常"),
    E_1004(1004, "参数值为空"),
    /* 保存 更新 重置 删除 等 */
    E_1005(1005,"更新失败"),
    E_1006(1006,"无结果"),
    E_1007(1007,"未登录"),
    E_1008(1008,"请求超时"),
    E_1009(1009,"请求下游服务异常"),
    E_1010(1010,"数据保存失败"),
    E_1011(1011,"数据重复"),
    E_9999(9999,"系统异常"),

    SUCCESS(200,"请求成功");

    private int code;

    private String msg;

    ResponseEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

}