package im.dx.system.controller;

import im.dx.common.shiro.ShiroActionProperties;
import im.dx.common.util.DateUtils;
import im.dx.common.util.ResultBean;
import im.dx.system.model.User;
import im.dx.system.service.UserService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

@Controller
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private UserService userService;


    @Autowired
    private ShiroActionProperties shiroActionProperties;

    @GetMapping(value = { "/","/login"})
    public String login(Model model) {
        model.addAttribute("loginVerify", shiroActionProperties.getLoginVerify());
        return "login";
    }

//    @GetMapping("/register")
//    public String register() {
//        return "register";
//    }

    @PostMapping("/login")
    @ResponseBody
    public ResultBean login(User user, @RequestParam(value = "captcha", required = false) String captcha,HttpServletResponse response) {
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(user.getUsername(), user.getPassword());
        try {
            subject.login(token);
        }catch (Exception ex){
            log.error(ex.toString());
            return ResultBean.error("用户名或者密码错误");
        }
        userService.updateLastLoginTimeByUsername(user.getUsername(), DateUtils.dateTimeNow("YYYY/MM/dd HH:mm:ss"));
        //查询用户操作权限一级菜单
        User cuser= userService.selectOneByUserName(user.getUsername());
        return ResultBean.success(cuser);
    }

    /***
     * 注销
     * @return
     */
    @GetMapping("/logout")
    public String logout() {
        SecurityUtils.getSubject().logout();
        return "redirect:login";
    }

    /***
     * 用户账号查询权限
     * @param username
     * @return
     */
    @PostMapping("/firstmenu")
    @ResponseBody
    public ResultBean firstmenu(String username) {
        if (null!=username && shiroActionProperties.getSuperAdminUsername().equals(username)) {
            username = null;
            return ResultBean.success(userService.selectUserFirstMenu(username));
        }
        else if(null!=username) {
            return ResultBean.success(userService.selectUserFirstMenu(username));
        }
        return ResultBean.success();
    }

    /***
     * 用户账号查询权限
     * @param menuid
     * @param username
     * @return
     */
    @PostMapping("/secondmenu")
    @ResponseBody
    public ResultBean secondmenu(Integer menuid,String username) {
        if (null!=username && shiroActionProperties.getSuperAdminUsername().equals(username)) {
            username = null;
            return ResultBean.success(userService.selectUserSecondMenu(menuid,username));
        }
        else if(null!=username) {
            return ResultBean.success(userService.selectUserSecondMenu(menuid,username));
        }

        return ResultBean.success();
    }



}
